/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.CompositeImage;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.GenericDialog;
import ij.gui.TrimmedButton;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.PlugIn;
import ij.plugin.Thresholder;
import ij.plugin.frame.PasteController;
import ij.plugin.frame.PlugInFrame;
import ij.plugin.frame.Recorder;
import ij.plugin.frame.ThresholdPlot;
import ij.process.AutoThresholder;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;

public class ThresholdAdjuster
extends PlugInFrame
implements PlugIn,
Measurements,
Runnable,
ActionListener,
AdjustmentListener,
ItemListener {
    public static final String LOC_KEY = "threshold.loc";
    public static final String MODE_KEY = "threshold.mode";
    public static final String DARK_BACKGROUND = "threshold.dark";
    static final int RED = 0;
    static final int BLACK_AND_WHITE = 1;
    static final int OVER_UNDER = 2;
    static final String[] modes = new String[]{"Red", "B&W", "Over/Under"};
    static final double defaultMinThreshold = 85.0;
    static final double defaultMaxThreshold = 170.0;
    static final int DEFAULT = 0;
    static boolean fill1 = true;
    static boolean fill2 = true;
    static boolean useBW = true;
    static boolean backgroundToNaN = true;
    static ThresholdAdjuster instance;
    static int mode;
    static String[] methodNames;
    static String method;
    static AutoThresholder thresholder;
    ThresholdPlot plot = new ThresholdPlot();
    Thread thread;
    int minValue = -1;
    int maxValue = -1;
    int sliderRange = 256;
    boolean doAutoAdjust;
    boolean doReset;
    boolean doApplyLut;
    boolean doStateChange;
    boolean doSet;
    Panel panel;
    Button autoB;
    Button resetB;
    Button applyB;
    Button setB;
    int previousImageID;
    int previousImageType;
    double previousMin;
    double previousMax;
    int previousSlice;
    ImageJ ij;
    double minThreshold;
    double maxThreshold;
    Scrollbar minSlider;
    Scrollbar maxSlider;
    Label label1;
    Label label2;
    boolean done;
    boolean invertedLut;
    int lutColor;
    Choice methodChoice;
    Choice modeChoice;
    Checkbox darkBackground;
    Checkbox stackHistogram;
    boolean firstActivation;
    boolean useExistingTheshold;
    static final int RESET = 0;
    static final int AUTO = 1;
    static final int HIST = 2;
    static final int APPLY = 3;
    static final int STATE_CHANGE = 4;
    static final int MIN_THRESHOLD = 5;
    static final int MAX_THRESHOLD = 6;
    static final int SET = 7;

    public ThresholdAdjuster() {
        super("Threshold");
        int i;
        ImagePlus cimp = WindowManager.getCurrentImage();
        if (cimp != null && cimp.getBitDepth() == 24) {
            IJ.run(cimp, "Color Threshold...", "");
            return;
        }
        if (instance != null) {
            ThresholdAdjuster.instance.firstActivation = true;
            WindowManager.toFront(instance);
            return;
        }
        WindowManager.addWindow(this);
        instance = this;
        mode = (int)Prefs.get(MODE_KEY, 0.0);
        if (mode < 0 || mode > 2) {
            mode = 0;
        }
        this.setLutColor(mode);
        IJ.register(PasteController.class);
        this.ij = IJ.getInstance();
        Font font = new Font("SansSerif", 0, 10);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        int y = 0;
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.plot, c);
        this.plot.addKeyListener(this.ij);
        this.minSlider = new Scrollbar(0, this.sliderRange / 3, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        c.fill = 2;
        c.insets = new Insets(5, 10, 0, 0);
        this.add((Component)this.minSlider, c);
        this.minSlider.addAdjustmentListener(this);
        this.minSlider.addKeyListener(this.ij);
        this.minSlider.setUnitIncrement(1);
        this.minSlider.setFocusable(false);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = IJ.isMacintosh() ? 10.0 : 0.0;
        c.insets = new Insets(5, 0, 0, 10);
        this.label1 = new Label("       ", 2);
        this.label1.setFont(font);
        this.add((Component)this.label1, c);
        this.maxSlider = new Scrollbar(0, this.sliderRange * 2 / 3, 1, 0, this.sliderRange);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 1;
        c.weightx = 100.0;
        c.insets = new Insets(2, 10, 0, 0);
        this.add((Component)this.maxSlider, c);
        this.maxSlider.addAdjustmentListener(this);
        this.maxSlider.addKeyListener(this.ij);
        this.maxSlider.setUnitIncrement(1);
        this.maxSlider.setFocusable(false);
        c.gridx = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(2, 0, 0, 10);
        this.label2 = new Label("       ", 2);
        this.label2.setFont(font);
        this.add((Component)this.label2, c);
        this.panel = new Panel();
        this.methodChoice = new Choice();
        for (i = 0; i < methodNames.length; ++i) {
            this.methodChoice.addItem(methodNames[i]);
        }
        this.methodChoice.select(method);
        this.methodChoice.addItemListener(this);
        this.panel.add(this.methodChoice);
        this.modeChoice = new Choice();
        for (i = 0; i < modes.length; ++i) {
            this.modeChoice.addItem(modes[i]);
        }
        this.modeChoice.select(mode);
        this.modeChoice.addItemListener(this);
        this.panel.add(this.modeChoice);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(8, 5, 0, 5);
        c.anchor = 10;
        c.fill = 0;
        this.add((Component)this.panel, c);
        this.panel = new Panel();
        boolean db = Prefs.get(DARK_BACKGROUND, Prefs.blackBackground);
        this.darkBackground = new Checkbox("Dark background");
        this.darkBackground.setState(db);
        this.darkBackground.addItemListener(this);
        this.panel.add(this.darkBackground);
        this.stackHistogram = new Checkbox("Stack histogram");
        this.stackHistogram.setState(false);
        this.stackHistogram.addItemListener(this);
        this.panel.add(this.stackHistogram);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.panel, c);
        int trim = IJ.isMacOSX() ? 11 : 0;
        this.panel = new Panel();
        this.autoB = new TrimmedButton("Auto", trim);
        this.autoB.addActionListener(this);
        this.autoB.addKeyListener(this.ij);
        this.panel.add(this.autoB);
        this.applyB = new TrimmedButton("Apply", trim);
        this.applyB.addActionListener(this);
        this.applyB.addKeyListener(this.ij);
        this.panel.add(this.applyB);
        this.resetB = new TrimmedButton("Reset", trim);
        this.resetB.addActionListener(this);
        this.resetB.addKeyListener(this.ij);
        this.panel.add(this.resetB);
        this.setB = new TrimmedButton("Set", trim);
        this.setB.addActionListener(this);
        this.setB.addKeyListener(this.ij);
        this.panel.add(this.setB);
        c.gridx = 0;
        c.gridy = y++;
        c.gridwidth = 2;
        c.insets = new Insets(0, 5, 10, 5);
        this.add((Component)this.panel, c);
        this.addKeyListener(this.ij);
        this.pack();
        Point loc = Prefs.getLocation(LOC_KEY);
        if (loc != null) {
            this.setLocation(loc);
        } else {
            GUI.center(this);
        }
        if (IJ.isMacOSX()) {
            this.setResizable(false);
        }
        this.show();
        this.thread = new Thread((Runnable)this, "ThresholdAdjuster");
        this.thread.start();
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            this.useExistingTheshold = this.isThresholded(imp);
            this.setup(imp);
        }
    }

    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.minSlider) {
            this.minValue = this.minSlider.getValue();
        } else {
            this.maxValue = this.maxSlider.getValue();
        }
        this.notify();
    }

    public synchronized void actionPerformed(ActionEvent e) {
        Button b = (Button)e.getSource();
        if (b == null) {
            return;
        }
        if (b == this.resetB) {
            this.doReset = true;
        } else if (b == this.autoB) {
            this.doAutoAdjust = true;
        } else if (b == this.applyB) {
            this.doApplyLut = true;
        } else if (b == this.setB) {
            this.doSet = true;
        }
        this.notify();
    }

    void setLutColor(int mode) {
        switch (mode) {
            case 0: {
                this.lutColor = 0;
                break;
            }
            case 1: {
                this.lutColor = 1;
                break;
            }
            case 2: {
                this.lutColor = 3;
            }
        }
    }

    public synchronized void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.methodChoice) {
            method = this.methodChoice.getSelectedItem();
            this.doAutoAdjust = true;
        } else if (source == this.modeChoice) {
            mode = this.modeChoice.getSelectedIndex();
            this.setLutColor(mode);
            this.doStateChange = true;
        } else {
            this.doAutoAdjust = true;
        }
        this.notify();
    }

    ImageProcessor setup(ImagePlus imp) {
        int type = imp.getType();
        if (type == 4 || imp.isComposite() && ((CompositeImage)imp).getMode() == 1) {
            return null;
        }
        ImageProcessor ip = imp.getProcessor();
        boolean minMaxChange = false;
        boolean not8Bits = type == 1 || type == 2;
        int slice = imp.getCurrentSlice();
        if (not8Bits) {
            if (ip.getMin() == this.plot.stackMin && ip.getMax() == this.plot.stackMax) {
                minMaxChange = false;
            } else if (ip.getMin() != this.previousMin || ip.getMax() != this.previousMax) {
                minMaxChange = true;
                this.previousMin = ip.getMin();
                this.previousMax = ip.getMax();
            } else if (slice != this.previousSlice) {
                minMaxChange = true;
            }
        }
        int id = imp.getID();
        if (minMaxChange || id != this.previousImageID || type != this.previousImageType) {
            Undo.reset();
            if (not8Bits && minMaxChange && !this.useExistingTheshold) {
                ip.resetMinAndMax();
                imp.updateAndDraw();
            }
            this.useExistingTheshold = false;
            this.invertedLut = imp.isInvertedLut();
            this.minThreshold = ip.getMinThreshold();
            this.maxThreshold = ip.getMaxThreshold();
            ImageStatistics stats = this.plot.setHistogram(imp, this.entireStack(imp));
            if (this.minThreshold == -808080.0) {
                this.autoSetLevels(ip, stats);
            } else {
                this.minThreshold = this.scaleDown(ip, this.minThreshold);
                this.maxThreshold = this.scaleDown(ip, this.maxThreshold);
            }
            this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
            this.updateLabels(imp, ip);
            this.updatePlot();
            this.updateScrollBars();
            imp.updateAndDraw();
        }
        this.previousImageID = id;
        this.previousImageType = type;
        this.previousSlice = slice;
        return ip;
    }

    boolean entireStack(ImagePlus imp) {
        return this.stackHistogram != null && this.stackHistogram.getState() && imp.getStackSize() > 1;
    }

    void autoSetLevels(ImageProcessor ip, ImageStatistics stats) {
        if (stats == null || stats.histogram == null) {
            this.minThreshold = 85.0;
            this.maxThreshold = 170.0;
            return;
        }
        boolean darkb = this.darkBackground != null && this.darkBackground.getState();
        int modifiedModeCount = stats.histogram[stats.mode];
        if (!method.equals(methodNames[0])) {
            stats.histogram[stats.mode] = this.plot.originalModeCount;
        }
        int threshold = thresholder.getThreshold(method, stats.histogram);
        stats.histogram[stats.mode] = modifiedModeCount;
        if (darkb) {
            if (this.invertedLut) {
                this.minThreshold = 0.0;
                this.maxThreshold = threshold;
            } else {
                this.minThreshold = threshold + 1;
                this.maxThreshold = 255.0;
            }
        } else if (this.invertedLut) {
            this.minThreshold = threshold + 1;
            this.maxThreshold = 255.0;
        } else {
            this.minThreshold = 0.0;
            this.maxThreshold = threshold;
        }
        if (this.minThreshold > 255.0) {
            this.minThreshold = 255.0;
        }
        if (Recorder.record) {
            boolean stack = this.stackHistogram != null && this.stackHistogram.getState();
            String options = method + (darkb ? " dark" : "") + (stack ? " stack" : "");
            if (Recorder.scriptMode()) {
                Recorder.recordCall("IJ.setAutoThreshold(imp, \"" + options + "\");");
            } else {
                Recorder.record("setAutoThreshold", options);
            }
        }
    }

    void scaleUpAndSet(ImageProcessor ip, double minThreshold, double maxThreshold) {
        if (!(ip instanceof ByteProcessor) && minThreshold != -808080.0) {
            double min = ip.getMin();
            double max = ip.getMax();
            if (max > min) {
                minThreshold = min + minThreshold / 255.0 * (max - min);
                maxThreshold = min + maxThreshold / 255.0 * (max - min);
            } else {
                minThreshold = maxThreshold = min;
            }
        }
        ip.setThreshold(minThreshold, maxThreshold, this.lutColor);
        ip.setSnapshotPixels(null);
    }

    double scaleDown(ImageProcessor ip, double threshold) {
        if (ip instanceof ByteProcessor) {
            return threshold;
        }
        double min = ip.getMin();
        double max = ip.getMax();
        if (max > min) {
            return (threshold - min) / (max - min) * 255.0;
        }
        return -808080.0;
    }

    double scaleUp(ImageProcessor ip, double threshold) {
        double min = ip.getMin();
        double max = ip.getMax();
        if (max > min) {
            return min + threshold / 255.0 * (max - min);
        }
        return -808080.0;
    }

    void updatePlot() {
        this.plot.minThreshold = this.minThreshold;
        this.plot.maxThreshold = this.maxThreshold;
        this.plot.mode = mode;
        this.plot.repaint();
    }

    void updateLabels(ImagePlus imp, ImageProcessor ip) {
        double min = ip.getMinThreshold();
        double max = ip.getMaxThreshold();
        if (min == -808080.0) {
            this.label1.setText("");
            this.label2.setText("");
        } else {
            Calibration cal = imp.getCalibration();
            if (cal.calibrated()) {
                min = cal.getCValue((int)min);
                max = cal.getCValue((int)max);
            }
            if ((double)((int)min) == min && (double)((int)max) == max || ip instanceof ShortProcessor) {
                this.label1.setText("" + (int)min);
                this.label2.setText("" + (int)max);
            } else {
                this.label1.setText("" + IJ.d2s(min, 2));
                this.label2.setText("" + IJ.d2s(max, 2));
            }
        }
    }

    void updateScrollBars() {
        this.minSlider.setValue((int)this.minThreshold);
        this.maxSlider.setValue((int)this.maxThreshold);
    }

    void doMasking(ImagePlus imp, ImageProcessor ip) {
        ImageProcessor mask = imp.getMask();
        if (mask != null) {
            ip.reset(mask);
        }
    }

    void adjustMinThreshold(ImagePlus imp, ImageProcessor ip, double value) {
        if (IJ.altKeyDown() || IJ.shiftKeyDown()) {
            double width = this.maxThreshold - this.minThreshold;
            if (width < 1.0) {
                width = 1.0;
            }
            this.minThreshold = value;
            this.maxThreshold = this.minThreshold + width;
            if (this.minThreshold + width > 255.0) {
                this.minThreshold = 255.0 - width;
                this.maxThreshold = this.minThreshold + width;
                this.minSlider.setValue((int)this.minThreshold);
            }
            this.maxSlider.setValue((int)this.maxThreshold);
            this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
            return;
        }
        this.minThreshold = value;
        if (this.maxThreshold < this.minThreshold) {
            this.maxThreshold = this.minThreshold;
            this.maxSlider.setValue((int)this.maxThreshold);
        }
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
    }

    void adjustMaxThreshold(ImagePlus imp, ImageProcessor ip, int cvalue) {
        this.maxThreshold = cvalue;
        if (this.minThreshold > this.maxThreshold) {
            this.minThreshold = this.maxThreshold;
            this.minSlider.setValue((int)this.minThreshold);
        }
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
        IJ.setKeyUp(18);
        IJ.setKeyUp(16);
    }

    void reset(ImagePlus imp, ImageProcessor ip) {
        ip.resetThreshold();
        ImageStatistics stats = this.plot.setHistogram(imp, this.entireStack(imp));
        if (!(ip instanceof ByteProcessor)) {
            if (this.entireStack(imp)) {
                ip.setMinAndMax(stats.min, stats.max);
            } else {
                ip.resetMinAndMax();
            }
        }
        this.updateScrollBars();
        if (Recorder.record) {
            if (Recorder.scriptMode()) {
                Recorder.recordCall("IJ.resetThreshold(imp);");
            } else {
                Recorder.record("resetThreshold");
            }
        }
    }

    void doSet(ImagePlus imp, ImageProcessor ip) {
        double level1 = ip.getMinThreshold();
        double level2 = ip.getMaxThreshold();
        if (level1 == -808080.0) {
            level1 = this.scaleUp(ip, 85.0);
            level2 = this.scaleUp(ip, 170.0);
        }
        Calibration cal = imp.getCalibration();
        int digits = ip instanceof FloatProcessor || cal.calibrated() ? 2 : 0;
        level1 = cal.getCValue(level1);
        level2 = cal.getCValue(level2);
        GenericDialog gd = new GenericDialog("Set Threshold Levels");
        gd.addNumericField("Lower Threshold Level: ", level1, digits);
        gd.addNumericField("Upper Threshold Level: ", level2, digits);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        level1 = gd.getNextNumber();
        level2 = gd.getNextNumber();
        level1 = cal.getRawValue(level1);
        if ((level2 = cal.getRawValue(level2)) < level1) {
            level2 = level1;
        }
        double minDisplay = ip.getMin();
        double maxDisplay = ip.getMax();
        ip.resetMinAndMax();
        double minValue = ip.getMin();
        double maxValue = ip.getMax();
        if (level1 < minValue) {
            level1 = minValue;
        }
        if (level2 > maxValue) {
            level2 = maxValue;
        }
        IJ.wait(500);
        ip.setThreshold(level1, level2, this.lutColor);
        ip.setSnapshotPixels(null);
        this.setup(imp);
        if (Recorder.record) {
            if (imp.getBitDepth() == 32) {
                if (Recorder.scriptMode()) {
                    Recorder.recordCall("IJ.setThreshold(" + ip.getMinThreshold() + ", " + ip.getMaxThreshold() + ");");
                } else {
                    Recorder.record("setThreshold", ip.getMinThreshold(), ip.getMaxThreshold());
                }
            } else {
                int min = (int)ip.getMinThreshold();
                int max = (int)ip.getMaxThreshold();
                if (cal.isSigned16Bit()) {
                    min = (int)cal.getCValue(level1);
                    max = (int)cal.getCValue(level2);
                }
                if (Recorder.scriptMode()) {
                    Recorder.recordCall("IJ.setThreshold(imp, " + min + ", " + max + ");");
                } else {
                    Recorder.record("setThreshold", min, max);
                }
            }
        }
    }

    void changeState(ImagePlus imp, ImageProcessor ip) {
        this.scaleUpAndSet(ip, this.minThreshold, this.maxThreshold);
        this.updateScrollBars();
    }

    void autoThreshold(ImagePlus imp, ImageProcessor ip) {
        ip.resetThreshold();
        this.previousImageID = 0;
        this.setup(imp);
    }

    void apply(ImagePlus imp) {
        try {
            if (imp.getBitDepth() == 32) {
                GenericDialog gd = new GenericDialog("NaN Backround");
                gd.addCheckbox("Set Background Pixels to NaN", backgroundToNaN);
                gd.showDialog();
                if (gd.wasCanceled()) {
                    this.runThresholdCommand();
                    return;
                }
                backgroundToNaN = gd.getNextBoolean();
                if (backgroundToNaN) {
                    Recorder.recordInMacros = true;
                    IJ.run("NaN Background");
                    Recorder.recordInMacros = false;
                } else {
                    this.runThresholdCommand();
                }
            } else {
                this.runThresholdCommand();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void runThresholdCommand() {
        Thresholder.setMethod(method);
        Thresholder.setBackground(this.darkBackground.getState() ? "Dark" : "Light");
        if (Recorder.record) {
            Recorder.setCommand("Convert to Mask");
            new Thresholder().run("mask");
            Recorder.saveCommand();
        } else {
            new Thresholder().run("mask");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.done) {
            ThresholdAdjuster thresholdAdjuster = this;
            synchronized (thresholdAdjuster) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.doUpdate();
        }
    }

    void doUpdate() {
        int action;
        int min = this.minValue;
        int max = this.maxValue;
        if (this.doReset) {
            action = 0;
        } else if (this.doAutoAdjust) {
            action = 1;
        } else if (this.doApplyLut) {
            action = 3;
        } else if (this.doStateChange) {
            action = 4;
        } else if (this.doSet) {
            action = 7;
        } else if (this.minValue >= 0) {
            action = 5;
        } else if (this.maxValue >= 0) {
            action = 6;
        } else {
            return;
        }
        this.minValue = -1;
        this.maxValue = -1;
        this.doReset = false;
        this.doAutoAdjust = false;
        this.doApplyLut = false;
        this.doStateChange = false;
        this.doSet = false;
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.beep();
            IJ.showStatus("No image");
            return;
        }
        ImageProcessor ip = this.setup(imp);
        if (ip == null) {
            imp.unlock();
            IJ.beep();
            if (imp.isComposite()) {
                IJ.showStatus("\"Composite\" mode images cannot be thresholded");
            } else {
                IJ.showStatus("RGB images cannot be thresholded");
            }
            return;
        }
        switch (action) {
            case 0: {
                this.reset(imp, ip);
                break;
            }
            case 1: {
                this.autoThreshold(imp, ip);
                break;
            }
            case 3: {
                this.apply(imp);
                break;
            }
            case 4: {
                this.changeState(imp, ip);
                break;
            }
            case 7: {
                this.doSet(imp, ip);
                break;
            }
            case 5: {
                this.adjustMinThreshold(imp, ip, min);
                break;
            }
            case 6: {
                this.adjustMaxThreshold(imp, ip, max);
            }
        }
        this.updatePlot();
        this.updateLabels(imp, ip);
        ip.setLutAnimation(true);
        imp.updateAndDraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        instance = null;
        this.done = true;
        Prefs.saveLocation(LOC_KEY, this.getLocation());
        Prefs.set(MODE_KEY, mode);
        Prefs.set(DARK_BACKGROUND, this.darkBackground.getState());
        ThresholdAdjuster thresholdAdjuster = this;
        synchronized (thresholdAdjuster) {
            this.notify();
        }
    }

    public void windowActivated(WindowEvent e) {
        super.windowActivated(e);
        this.plot.requestFocus();
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null && this.firstActivation) {
            this.previousImageID = 0;
            this.useExistingTheshold = this.isThresholded(imp);
            this.setup(imp);
            this.firstActivation = false;
        }
    }

    boolean isThresholded(ImagePlus imp) {
        ImageProcessor ip = imp.getProcessor();
        return ip.getMinThreshold() != -808080.0 && ip.isColorLut();
    }

    public static void update() {
        if (instance != null) {
            ThresholdAdjuster ta = instance;
            ImagePlus imp = WindowManager.getCurrentImage();
            if (imp != null && ta.previousImageID == imp.getID()) {
                ta.previousImageID = 0;
                ta.setup(imp);
            }
        }
    }

    public static String getMethod() {
        return method;
    }

    public static String getMode() {
        return modes[mode];
    }

    static {
        mode = 0;
        methodNames = AutoThresholder.getMethods();
        method = methodNames[0];
        thresholder = new AutoThresholder();
    }
}

