/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Prefs;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.ContrastEnhancer;
import ij.plugin.filter.ExtendedPlugInFilter;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.util.Arrays;

public class RankFilters
implements ExtendedPlugInFilter,
DialogListener {
    public static final int MEAN = 0;
    public static final int MIN = 1;
    public static final int MAX = 2;
    public static final int VARIANCE = 3;
    public static final int MEDIAN = 4;
    public static final int OUTLIERS = 5;
    public static final int DESPECKLE = 6;
    public static final int REMOVE_NAN = 7;
    public static final int OPEN = 8;
    public static final int CLOSE = 9;
    private static int HIGHEST_FILTER = 9;
    private static final int BRIGHT_OUTLIERS = 0;
    private static final int DARK_OUTLIERS = 1;
    private static final String[] outlierStrings = new String[]{"Bright", "Dark"};
    private double radius;
    private double threshold;
    private int whichOutliers;
    private int filterType;
    private static double[] lastRadius = new double[HIGHEST_FILTER + 1];
    private static double lastThreshold = 50.0;
    private static int lastWhichOutliers = 0;
    int flags = 16777311;
    private ImagePlus imp;
    private int nPasses = 1;
    private PlugInFilterRunner pfr;
    private int pass;
    private int numThreads = Prefs.getThreads();
    private int highestYinCache;
    private boolean threadWaiting;
    private boolean copyingToCache;

    private boolean isMultiStepFilter(int filterType) {
        return filterType >= 8;
    }

    public int setup(String arg, ImagePlus imp) {
        Roi roi;
        this.imp = imp;
        if (arg.equals("mean")) {
            this.filterType = 0;
        } else if (arg.equals("min")) {
            this.filterType = 1;
        } else if (arg.equals("max")) {
            this.filterType = 2;
        } else if (arg.equals("variance")) {
            this.filterType = 3;
            this.flags |= 0x10000;
        } else if (arg.equals("median")) {
            this.filterType = 4;
        } else if (arg.equals("outliers")) {
            this.filterType = 5;
        } else if (arg.equals("despeckle")) {
            this.filterType = 6;
        } else if (arg.equals("close")) {
            this.filterType = 9;
        } else if (arg.equals("open")) {
            this.filterType = 8;
        } else if (arg.equals("nan")) {
            this.filterType = 7;
            if (imp != null && imp.getBitDepth() != 32) {
                IJ.error("RankFilters", "\"Remove NaNs\" requires a 32-bit image");
                return 4096;
            }
        } else if (arg.equals("final")) {
            if (imp != null && imp.getBitDepth() != 8 && imp.getBitDepth() != 24 && imp.getRoi() == null) {
                new ContrastEnhancer().stretchHistogram(imp.getProcessor(), 0.5);
            }
        } else {
            if (arg.equals("masks")) {
                this.showMasks();
                return 4096;
            }
            IJ.error("RankFilters", "Argument missing or undefined: " + arg);
            return 4096;
        }
        if (this.isMultiStepFilter(this.filterType) && imp != null && (roi = imp.getRoi()) != null && !roi.getBounds().contains(new Rectangle(imp.getWidth(), imp.getHeight()))) {
            this.flags |= 0x4000;
        }
        return this.flags;
    }

    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        if (this.filterType == 6) {
            this.filterType = 4;
            this.radius = 1.0;
        } else {
            int digits;
            GenericDialog gd = new GenericDialog(command + "...");
            this.radius = lastRadius[this.filterType] <= 0.0 ? 2.0 : lastRadius[this.filterType];
            gd.addNumericField("Radius", this.radius, 1, 6, "pixels");
            int n = digits = imp.getType() == 2 ? 2 : 0;
            if (this.filterType == 5) {
                gd.addNumericField("Threshold", lastThreshold, digits);
                gd.addChoice("Which outliers", outlierStrings, outlierStrings[lastWhichOutliers]);
                gd.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#outliers");
            } else if (this.filterType == 7) {
                gd.addHelp("http://imagej.nih.gov/ij/docs/menus/process.html#nans");
            }
            gd.addPreviewCheckbox(pfr);
            gd.addDialogListener(this);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return 4096;
            }
            IJ.register(this.getClass());
            if (Macro.getOptions() == null) {
                RankFilters.lastRadius[this.filterType] = this.radius;
                if (this.filterType == 5) {
                    lastThreshold = this.threshold;
                    lastWhichOutliers = this.whichOutliers;
                }
            }
        }
        this.pfr = pfr;
        this.flags = IJ.setupDialog(imp, this.flags);
        if ((this.flags & 0x20) != 0) {
            int size = imp.getWidth() * imp.getHeight();
            Roi roi = imp.getRoi();
            if (roi != null) {
                Rectangle roiRect = roi.getBounds();
                size = roiRect.width * roiRect.height;
            }
            double workToDo = (double)size * this.radius;
            if (this.filterType == 0 || this.filterType == 3) {
                workToDo *= 0.5;
            } else if (this.filterType == 4) {
                workToDo *= this.radius * 0.5;
            }
            if (workToDo < 1000000.0 && imp.getImageStackSize() >= this.numThreads) {
                this.numThreads = 1;
                this.flags |= 0x8000;
            }
        }
        return this.flags;
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        int maxRadius;
        this.radius = gd.getNextNumber();
        if (this.filterType == 5) {
            this.threshold = gd.getNextNumber();
            this.whichOutliers = gd.getNextChoiceIndex();
        }
        int n = maxRadius = this.filterType == 4 || this.filterType == 5 || this.filterType == 7 ? 100 : 1000;
        return !gd.invalidNumber() && !(this.radius < 0.0) && !(this.radius > (double)maxRadius) && (this.filterType != 5 || !(this.threshold < 0.0));
    }

    public void run(ImageProcessor ip) {
        this.rank(ip, this.radius, this.filterType, this.whichOutliers, (float)this.threshold);
        if (IJ.escapePressed()) {
            ip.reset();
        }
    }

    public void rank(ImageProcessor ip, double radius, int filterType) {
        this.rank(ip, radius, filterType, 0, 50.0f);
    }

    public void rank(ImageProcessor ip, double radius, int filterType, int whichOutliers, float threshold) {
        Rectangle roi = ip.getRoi();
        ImageProcessor mask = ip.getMask();
        Rectangle roi1 = null;
        int[] lineRadii = this.makeLineRadii(radius);
        boolean isImagePart = roi.width < ip.getWidth() || roi.height < ip.getHeight();
        boolean[] aborted = new boolean[1];
        for (int ch = 0; ch < ip.getNChannels(); ++ch) {
            int filterType1 = filterType;
            if (this.isMultiStepFilter(filterType)) {
                int n = filterType1 = filterType == 8 ? 1 : 2;
                if (isImagePart) {
                    int kRadius = this.kRadius(lineRadii);
                    int kHeight = this.kHeight(lineRadii);
                    Rectangle roiClone = (Rectangle)roi.clone();
                    roiClone.grow(kRadius, kHeight / 2);
                    roi1 = roiClone.intersection(new Rectangle(ip.getWidth(), ip.getHeight()));
                    ip.setRoi(roi1);
                }
            }
            this.doFiltering(ip, lineRadii, filterType1, whichOutliers, threshold, ch, aborted);
            if (aborted[0]) break;
            if (!this.isMultiStepFilter(filterType)) continue;
            ip.setRoi(roi);
            ip.setMask(mask);
            int filterType2 = filterType == 8 ? 2 : 1;
            this.doFiltering(ip, lineRadii, filterType2, whichOutliers, threshold, ch, aborted);
            if (aborted[0]) break;
            if (!isImagePart) continue;
            this.resetRoiBoundary(ip, roi, roi1);
        }
    }

    private void doFiltering(final ImageProcessor ip, final int[] lineRadii, final int filterType, final int whichOutliers, final float threshold, final int colorChannel, final boolean[] aborted) {
        Rectangle roi = ip.getRoi();
        int width = ip.getWidth();
        Object pixels = ip.getPixels();
        int numThreads = Math.min(roi.height, this.numThreads);
        int kHeight = this.kHeight(lineRadii);
        int kRadius = this.kRadius(lineRadii);
        final int cacheWidth = roi.width + 2 * kRadius;
        final int cacheHeight = kHeight + (numThreads > 1 ? 2 * numThreads : 0);
        final float[] cache = new float[cacheWidth * cacheHeight];
        this.highestYinCache = Math.max(roi.y - kHeight / 2, 0) - 1;
        final int[] yForThread = new int[numThreads];
        Arrays.fill(yForThread, -1);
        yForThread[numThreads - 1] = roi.y - 1;
        Thread[] threads = new Thread[numThreads - 1];
        for (int t = numThreads - 1; t > 0; --t) {
            final int ti = t;
            Thread thread = new Thread(new Runnable(){

                public final void run() {
                    RankFilters.this.doFiltering(ip, lineRadii, cache, cacheWidth, cacheHeight, filterType, whichOutliers, threshold, colorChannel, yForThread, ti, aborted);
                }
            }, "RankFilters-" + t);
            thread.setPriority(Thread.currentThread().getPriority());
            thread.start();
            threads[ti - 1] = thread;
        }
        this.doFiltering(ip, lineRadii, cache, cacheWidth, cacheHeight, filterType, whichOutliers, threshold, colorChannel, yForThread, 0, aborted);
        for (Thread thread : threads) {
            try {
                if (thread == null) continue;
                thread.join();
            }
            catch (InterruptedException e) {
                aborted[0] = true;
                Thread.currentThread().interrupt();
            }
        }
        this.showProgress(1.0, ip instanceof ColorProcessor);
        ++this.pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void doFiltering(ImageProcessor ip, int[] lineRadii, float[] cache, int cacheWidth, int cacheHeight, int filterType, int whichOutliers, float threshold, int colorChannel, int[] yForThread, int threadNumber, boolean[] aborted) {
        float sign;
        if (aborted[0]) return;
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        Rectangle roi = ip.getRoi();
        int kHeight = this.kHeight(lineRadii);
        int kRadius = this.kRadius(lineRadii);
        int kNPoints = this.kNPoints(lineRadii);
        int xmin = roi.x - kRadius;
        int xmax = roi.x + roi.width + kRadius;
        int[] cachePointers = this.makeCachePointers(lineRadii, cacheWidth);
        int padLeft = xmin < 0 ? -xmin : 0;
        int padRight = xmax > width ? xmax - width : 0;
        int xminInside = xmin > 0 ? xmin : 0;
        int xmaxInside = xmax < width ? xmax : width;
        int widthInside = xmaxInside - xminInside;
        boolean minOrMax = filterType == 1 || filterType == 2;
        boolean minOrMaxOrOutliers = minOrMax || filterType == 5;
        boolean sumFilter = filterType == 0 || filterType == 3;
        boolean medianFilter = filterType == 4 || filterType == 5;
        double[] sums = sumFilter ? new double[2] : null;
        float[] medianBuf1 = (float[])(medianFilter || filterType == 7 ? new float[kNPoints] : null);
        float[] medianBuf2 = (float[])(medianFilter || filterType == 7 ? new float[kNPoints] : null);
        float f = sign = filterType == 1 ? -1.0f : 1.0f;
        if (filterType == 5) {
            sign = ip.isInvertedLut() == (whichOutliers == 1) ? -1.0f : 1.0f;
        }
        boolean smallKernel = kRadius < 2;
        Object pixels = ip.getPixels();
        boolean isFloat = pixels instanceof float[];
        float maxValue = isFloat ? Float.NaN : (float)ip.maxValue();
        float[] values = isFloat ? (float[])pixels : new float[roi.width];
        int numThreads = yForThread.length;
        long lastTime = System.currentTimeMillis();
        int previousY = kHeight / 2 - cacheHeight;
        boolean rgb = ip instanceof ColorProcessor;
        while (!aborted[0]) {
            int slowestThreadY;
            long time;
            boolean threadFinished;
            int y;
            yForThread[threadNumber] = y = this.arrayMax(yForThread) + 1;
            boolean bl = threadFinished = y >= roi.y + roi.height;
            if (numThreads > 1 && (this.threadWaiting || threadFinished)) {
                RankFilters rankFilters = this;
                // MONITORENTER : rankFilters
                this.notifyAll();
                // MONITOREXIT : rankFilters
            }
            if (threadFinished) {
                return;
            }
            if (threadNumber == 0 && (time = System.currentTimeMillis()) - lastTime > 100L) {
                lastTime = time;
                this.showProgress((double)(y - roi.y) / (double)roi.height, rgb);
                if (Thread.currentThread().isInterrupted() || this.imp != null && IJ.escapePressed()) {
                    aborted[0] = true;
                    RankFilters rankFilters = this;
                    // MONITORENTER : rankFilters
                    this.notifyAll();
                    // MONITOREXIT : rankFilters
                    return;
                }
            }
            for (int i = 0; i < cachePointers.length; ++i) {
                cachePointers[i] = (cachePointers[i] + cacheWidth * (y - previousY)) % cache.length;
            }
            previousY = y;
            if (numThreads > 1 && y - (slowestThreadY = this.arrayMinNonNegative(yForThread)) + kHeight > cacheHeight) {
                RankFilters rankFilters = this;
                // MONITORENTER : rankFilters
                slowestThreadY = this.arrayMinNonNegative(yForThread);
                if (y - slowestThreadY + kHeight > cacheHeight) {
                    do {
                        this.notifyAll();
                        this.threadWaiting = true;
                        try {
                            this.wait();
                            if (aborted[0]) {
                                // MONITOREXIT : rankFilters
                                return;
                            }
                        }
                        catch (InterruptedException e) {
                            aborted[0] = true;
                            this.notifyAll();
                            Thread.currentThread().interrupt();
                            // MONITOREXIT : rankFilters
                            return;
                        }
                    } while (y - (slowestThreadY = this.arrayMinNonNegative(yForThread)) + kHeight > cacheHeight);
                }
                this.threadWaiting = false;
                // MONITOREXIT : rankFilters
            }
            if (numThreads == 1) {
                int yStartReading;
                for (int yNew = yStartReading = y == roi.y ? Math.max(roi.y - kHeight / 2, 0) : y + kHeight / 2; yNew <= y + kHeight / 2; ++yNew) {
                    RankFilters.readLineToCacheOrPad(pixels, width, height, roi.y, xminInside, widthInside, cache, cacheWidth, cacheHeight, padLeft, padRight, colorChannel, kHeight, yNew);
                }
            } else if (!this.copyingToCache || this.highestYinCache < y + kHeight / 2) {
                float[] yStartReading = cache;
                // MONITORENTER : cache
                this.copyingToCache = true;
                while (this.highestYinCache < this.arrayMinNonNegative(yForThread) - kHeight / 2 + cacheHeight - 1) {
                    int yNew = this.highestYinCache + 1;
                    RankFilters.readLineToCacheOrPad(pixels, width, height, roi.y, xminInside, widthInside, cache, cacheWidth, cacheHeight, padLeft, padRight, colorChannel, kHeight, yNew);
                    this.highestYinCache = yNew;
                }
                this.copyingToCache = false;
                // MONITOREXIT : yStartReading
            }
            int cacheLineP = cacheWidth * (y % cacheHeight) + kRadius;
            this.filterLine(values, width, cache, cachePointers, kNPoints, cacheLineP, roi, y, sums, medianBuf1, medianBuf2, sign, maxValue, isFloat, filterType, smallKernel, sumFilter, minOrMax, minOrMaxOrOutliers);
            if (isFloat) continue;
            RankFilters.writeLineToPixels(values, pixels, roi.x + y * width, roi.width, colorChannel);
        }
    }

    private int arrayMax(int[] array) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] <= max) continue;
            max = array[i];
        }
        return max;
    }

    private int arrayMinNonNegative(int[] array) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] < 0 || array[i] >= min) continue;
            min = array[i];
        }
        return min;
    }

    private void filterLine(float[] values, int width, float[] cache, int[] cachePointers, int kNPoints, int cacheLineP, Rectangle roi, int y, double[] sums, float[] medianBuf1, float[] medianBuf2, float sign, float maxValue, boolean isFloat, int filterType, boolean smallKernel, boolean sumFilter, boolean minOrMax, boolean minOrMaxOrOutliers) {
        int valuesP = isFloat ? roi.x + y * width : 0;
        float max = 0.0f;
        float median = Float.isNaN(cache[cacheLineP]) ? 0.0f : cache[cacheLineP];
        boolean fullCalculation = true;
        int x = 0;
        while (x < roi.width) {
            block23: {
                block24: {
                    block25: {
                        block21: {
                            block22: {
                                if (!fullCalculation) break block21;
                                fullCalculation = smallKernel;
                                if (minOrMaxOrOutliers) {
                                    max = RankFilters.getAreaMax(cache, x, cachePointers, 0, -3.4028235E38f, sign);
                                }
                                if (!minOrMax) break block22;
                                values[valuesP] = max * sign;
                                break block23;
                            }
                            if (sumFilter) {
                                RankFilters.getAreaSums(cache, x, cachePointers, sums);
                            }
                            break block24;
                        }
                        if (!minOrMaxOrOutliers) break block25;
                        float newPointsMax = RankFilters.getSideMax(cache, x, cachePointers, true, sign);
                        if (newPointsMax >= max) {
                            max = newPointsMax;
                        } else {
                            float removedPointsMax = RankFilters.getSideMax(cache, x, cachePointers, false, sign);
                            if (removedPointsMax >= max) {
                                max = RankFilters.getAreaMax(cache, x, cachePointers, 1, newPointsMax, sign);
                            }
                        }
                        if (!minOrMax) break block24;
                        values[valuesP] = max * sign;
                        break block23;
                    }
                    if (sumFilter) {
                        RankFilters.addSideSums(cache, x, cachePointers, sums);
                        if (Double.isNaN(sums[0])) {
                            fullCalculation = true;
                        }
                    }
                }
                if (sumFilter) {
                    if (filterType == 0) {
                        values[valuesP] = (float)(sums[0] / (double)kNPoints);
                    } else {
                        float value = (float)((sums[1] - sums[0] * sums[0] / (double)kNPoints) / (double)kNPoints);
                        if (value > maxValue) {
                            value = maxValue;
                        }
                        values[valuesP] = value;
                    }
                } else if (filterType == 4) {
                    values[valuesP] = median = RankFilters.getMedian(cache, x, cachePointers, medianBuf1, medianBuf2, kNPoints, median);
                } else if (filterType == 5) {
                    float v = cache[cacheLineP + x];
                    if ((double)(v * sign) + this.threshold < (double)max && (double)(v * sign) + this.threshold < (double)((median = RankFilters.getMedian(cache, x, cachePointers, medianBuf1, medianBuf2, kNPoints, median)) * sign)) {
                        v = median;
                    }
                    values[valuesP] = v;
                } else if (filterType == 7) {
                    if (Float.isNaN(values[valuesP])) {
                        values[valuesP] = RankFilters.getNaNAwareMedian(cache, x, cachePointers, medianBuf1, medianBuf2, kNPoints, median);
                    } else {
                        median = values[valuesP];
                    }
                }
            }
            ++x;
            ++valuesP;
        }
    }

    private static void readLineToCacheOrPad(Object pixels, int width, int height, int roiY, int xminInside, int widthInside, float[] cache, int cacheWidth, int cacheHeight, int padLeft, int padRight, int colorChannel, int kHeight, int y) {
        int lineInCache = y % cacheHeight;
        if (y < height) {
            RankFilters.readLineToCache(pixels, y * width, xminInside, widthInside, cache, lineInCache * cacheWidth, padLeft, padRight, colorChannel);
            if (y == 0) {
                for (int prevY = roiY - kHeight / 2; prevY < 0; ++prevY) {
                    int prevLineInCache = cacheHeight + prevY;
                    System.arraycopy(cache, 0, cache, prevLineInCache * cacheWidth, cacheWidth);
                }
            }
        } else {
            System.arraycopy(cache, cacheWidth * ((height - 1) % cacheHeight), cache, lineInCache * cacheWidth, cacheWidth);
        }
    }

    private static void readLineToCache(Object pixels, int pixelLineP, int xminInside, int widthInside, float[] cache, int cacheLineP, int padLeft, int padRight, int colorChannel) {
        int cp;
        int cp2;
        int pp;
        if (pixels instanceof byte[]) {
            byte[] bPixels = (byte[])pixels;
            pp = pixelLineP + xminInside;
            cp2 = cacheLineP + padLeft;
            while (pp < pixelLineP + xminInside + widthInside) {
                cache[cp2] = bPixels[pp] & 0xFF;
                ++pp;
                ++cp2;
            }
        } else if (pixels instanceof short[]) {
            short[] sPixels = (short[])pixels;
            pp = pixelLineP + xminInside;
            cp2 = cacheLineP + padLeft;
            while (pp < pixelLineP + xminInside + widthInside) {
                cache[cp2] = sPixels[pp] & 0xFFFF;
                ++pp;
                ++cp2;
            }
        } else if (pixels instanceof float[]) {
            System.arraycopy(pixels, pixelLineP + xminInside, cache, cacheLineP + padLeft, widthInside);
        } else {
            int[] cPixels = (int[])pixels;
            int shift = 16 - 8 * colorChannel;
            int byteMask = 255 << shift;
            int pp2 = pixelLineP + xminInside;
            int cp3 = cacheLineP + padLeft;
            while (pp2 < pixelLineP + xminInside + widthInside) {
                cache[cp3] = (cPixels[pp2] & byteMask) >> shift;
                ++pp2;
                ++cp3;
            }
        }
        for (cp = cacheLineP; cp < cacheLineP + padLeft; ++cp) {
            cache[cp] = cache[cacheLineP + padLeft];
        }
        for (cp = cacheLineP + padLeft + widthInside; cp < cacheLineP + padLeft + widthInside + padRight; ++cp) {
            cache[cp] = cache[cacheLineP + padLeft + widthInside - 1];
        }
    }

    private static void writeLineToPixels(float[] values, Object pixels, int pixelP, int length, int colorChannel) {
        if (pixels instanceof byte[]) {
            byte[] bPixels = (byte[])pixels;
            int i = 0;
            int p = pixelP;
            while (i < length) {
                bPixels[p] = (byte)((int)(values[i] + 0.5f) & 0xFF);
                ++i;
                ++p;
            }
        } else if (pixels instanceof short[]) {
            short[] sPixels = (short[])pixels;
            int i = 0;
            int p = pixelP;
            while (i < length) {
                sPixels[p] = (short)((int)(values[i] + 0.5f) & 0xFFFF);
                ++i;
                ++p;
            }
        } else {
            int[] cPixels = (int[])pixels;
            int shift = 16 - 8 * colorChannel;
            int resetMask = 0xFFFFFFFF ^ 255 << shift;
            int i = 0;
            int p = pixelP;
            while (i < length) {
                cPixels[p] = cPixels[p] & resetMask | (int)(values[i] + 0.5f) << shift;
                ++i;
                ++p;
            }
        }
    }

    private static float getAreaMax(float[] cache, int xCache0, int[] kernel, int ignoreRight, float max, float sign) {
        for (int kk = 0; kk < kernel.length; ++kk) {
            for (int p = kernel[kk++] + xCache0; p <= kernel[kk] + xCache0 - ignoreRight; ++p) {
                float v = cache[p] * sign;
                if (!(max < v)) continue;
                max = v;
            }
        }
        return max;
    }

    private static float getSideMax(float[] cache, int xCache0, int[] kernel, boolean isRight, float sign) {
        int kk;
        float max = -3.4028235E38f;
        if (!isRight) {
            --xCache0;
        }
        int n = kk = isRight ? 1 : 0;
        while (kk < kernel.length) {
            float v = cache[xCache0 + kernel[kk]] * sign;
            if (max < v) {
                max = v;
            }
            kk += 2;
        }
        return max;
    }

    private static void getAreaSums(float[] cache, int xCache0, int[] kernel, double[] sums) {
        double sum = 0.0;
        double sum2 = 0.0;
        for (int kk = 0; kk < kernel.length; ++kk) {
            for (int p = kernel[kk++] + xCache0; p <= kernel[kk] + xCache0; ++p) {
                float v = cache[p];
                sum += (double)v;
                sum2 += (double)(v * v);
            }
        }
        sums[0] = sum;
        sums[1] = sum2;
    }

    private static void addSideSums(float[] cache, int xCache0, int[] kernel, double[] sums) {
        double sum = 0.0;
        double sum2 = 0.0;
        int kk = 0;
        while (kk < kernel.length) {
            float v = cache[kernel[kk++] + (xCache0 - 1)];
            sum -= (double)v;
            sum2 -= (double)(v * v);
            v = cache[kernel[kk++] + xCache0];
            sum += (double)v;
            sum2 += (double)(v * v);
        }
        sums[0] = sums[0] + sum;
        sums[1] = sums[1] + sum2;
    }

    private static float getMedian(float[] cache, int xCache0, int[] kernel, float[] aboveBuf, float[] belowBuf, int kNPoints, float guess) {
        int nAbove = 0;
        int nBelow = 0;
        for (int kk = 0; kk < kernel.length; ++kk) {
            for (int p = kernel[kk++] + xCache0; p <= kernel[kk] + xCache0; ++p) {
                float v = cache[p];
                if (v > guess) {
                    aboveBuf[nAbove] = v;
                    ++nAbove;
                    continue;
                }
                if (!(v < guess)) continue;
                belowBuf[nBelow] = v;
                ++nBelow;
            }
        }
        int half = kNPoints / 2;
        if (nAbove > half) {
            return RankFilters.findNthLowestNumber(aboveBuf, nAbove, nAbove - half - 1);
        }
        if (nBelow > half) {
            return RankFilters.findNthLowestNumber(belowBuf, nBelow, half);
        }
        return guess;
    }

    private static float getNaNAwareMedian(float[] cache, int xCache0, int[] kernel, float[] aboveBuf, float[] belowBuf, int kNPoints, float guess) {
        int nAbove = 0;
        int nBelow = 0;
        for (int kk = 0; kk < kernel.length; ++kk) {
            for (int p = kernel[kk++] + xCache0; p <= kernel[kk] + xCache0; ++p) {
                float v = cache[p];
                if (Float.isNaN(v)) {
                    --kNPoints;
                    continue;
                }
                if (v > guess) {
                    aboveBuf[nAbove] = v;
                    ++nAbove;
                    continue;
                }
                if (!(v < guess)) continue;
                belowBuf[nBelow] = v;
                ++nBelow;
            }
        }
        if (kNPoints == 0) {
            return Float.NaN;
        }
        int half = kNPoints / 2;
        if (nAbove > half) {
            return RankFilters.findNthLowestNumber(aboveBuf, nAbove, nAbove - half - 1);
        }
        if (nBelow > half) {
            return RankFilters.findNthLowestNumber(belowBuf, nBelow, half);
        }
        return guess;
    }

    public static final float findNthLowestNumber(float[] buf, int bufLength, int n) {
        int l = 0;
        int m = bufLength - 1;
        float med = buf[n];
        while (l < m) {
            int i = l;
            int j = m;
            while (true) {
                if (buf[i] < med) {
                    ++i;
                    continue;
                }
                while (med < buf[j]) {
                    --j;
                }
                float dum = buf[j];
                buf[j] = buf[i];
                buf[i] = dum;
                if (--j < n || ++i > n) break;
            }
            if (j < n) {
                l = i;
            }
            if (n < i) {
                m = j;
            }
            med = buf[n];
        }
        return med;
    }

    private void resetRoiBoundary(ImageProcessor ip, Rectangle roi, Rectangle roi1) {
        int width = ip.getWidth();
        Object pixels = ip.getPixels();
        Object snapshot = ip.getSnapshotPixels();
        int y = roi1.y;
        int p = roi1.x + y * width;
        while (y < roi.y) {
            System.arraycopy(snapshot, p, pixels, p, roi1.width);
            ++y;
            p += width;
        }
        int leftWidth = roi.x - roi1.x;
        int rightWidth = roi1.x + roi1.width - (roi.x + roi.width);
        int y2 = roi.y;
        int pL = roi1.x + y2 * width;
        int pR = roi.x + roi.width + y2 * width;
        while (y2 < roi.y + roi.height) {
            if (leftWidth > 0) {
                System.arraycopy(snapshot, pL, pixels, pL, leftWidth);
            }
            if (rightWidth > 0) {
                System.arraycopy(snapshot, pR, pixels, pR, rightWidth);
            }
            ++y2;
            pL += width;
            pR += width;
        }
        y2 = roi.y + roi.height;
        int p2 = roi1.x + y2 * width;
        while (y2 < roi1.y + roi1.height) {
            System.arraycopy(snapshot, p2, pixels, p2, roi1.width);
            ++y2;
            p2 += width;
        }
    }

    public void makeKernel(double radius) {
        this.radius = radius;
    }

    protected int[] makeLineRadii(double radius) {
        if (radius >= 1.5 && radius < 1.75) {
            radius = 1.75;
        } else if (radius >= 2.5 && radius < 2.85) {
            radius = 2.85;
        }
        int r2 = (int)(radius * radius) + 1;
        int kRadius = (int)Math.sqrt((double)r2 + 1.0E-10);
        int kHeight = 2 * kRadius + 1;
        int[] kernel = new int[2 * kHeight + 2];
        kernel[2 * kRadius] = -kRadius;
        kernel[2 * kRadius + 1] = kRadius;
        int nPoints = 2 * kRadius + 1;
        for (int y = 1; y <= kRadius; ++y) {
            int dx = (int)Math.sqrt((double)(r2 - y * y) + 1.0E-10);
            kernel[2 * (kRadius - y)] = -dx;
            kernel[2 * (kRadius - y) + 1] = dx;
            kernel[2 * (kRadius + y)] = -dx;
            kernel[2 * (kRadius + y) + 1] = dx;
            nPoints += 4 * dx + 2;
        }
        kernel[kernel.length - 2] = nPoints;
        kernel[kernel.length - 1] = kRadius;
        return kernel;
    }

    private int kHeight(int[] lineRadii) {
        return (lineRadii.length - 2) / 2;
    }

    private int kRadius(int[] lineRadii) {
        return lineRadii[lineRadii.length - 1];
    }

    private int kNPoints(int[] lineRadii) {
        return lineRadii[lineRadii.length - 2];
    }

    private int[] makeCachePointers(int[] lineRadii, int cacheWidth) {
        int kRadius = this.kRadius(lineRadii);
        int kHeight = this.kHeight(lineRadii);
        int[] cachePointers = new int[2 * kHeight];
        for (int i = 0; i < kHeight; ++i) {
            cachePointers[2 * i] = i * cacheWidth + kRadius + lineRadii[2 * i];
            cachePointers[2 * i + 1] = i * cacheWidth + kRadius + lineRadii[2 * i + 1];
        }
        return cachePointers;
    }

    void showMasks() {
        int w = 150;
        int h = 150;
        ImageStack stack = new ImageStack(w, h);
        for (double r = 0.5; r < 50.0; r += 0.5) {
            FloatProcessor ip = new FloatProcessor(w, h, new int[w * h]);
            float[] pixels = (float[])((ImageProcessor)ip).getPixels();
            int[] lineRadii = this.makeLineRadii(r);
            int kHeight = this.kHeight(lineRadii);
            int kRadius = this.kRadius(lineRadii);
            int y0 = h / 2 - kHeight / 2;
            int i = 0;
            int y = y0;
            while (i < kHeight) {
                int x = w / 2 + lineRadii[2 * i];
                int p = x + y * w;
                while (x <= w / 2 + lineRadii[2 * i + 1]) {
                    pixels[p] = 1.0f;
                    ++x;
                    ++p;
                }
                ++i;
                ++y;
            }
            stack.addSlice("radius=" + r + ", size=" + (2 * kRadius + 1), ip);
        }
        new ImagePlus("Masks", stack).show();
    }

    public void setNPasses(int nPasses) {
        this.nPasses = nPasses;
        this.pass = 0;
    }

    private void showProgress(double percent, boolean rgb) {
        int nPasses2 = rgb ? this.nPasses * 3 : this.nPasses;
        percent = (double)this.pass / (double)nPasses2 + percent / (double)nPasses2;
        IJ.showProgress(percent);
    }
}

