/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.process.ImageProcessor;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;

class ThumbnailsCanvas
extends Canvas
implements MouseListener,
MouseMotionListener,
ActionListener {
    protected static Cursor handCursor = new Cursor(12);
    protected static Cursor defaultCursor = new Cursor(0);
    Image os;
    Graphics osg;
    CompositeImage cImp;
    int iconSize;
    int iconWidth;
    int iconHeight;
    int dx;
    int dy;
    int separatorY;
    int marginY;
    int marginX;
    int nChannels;
    int channelUnderCursor;
    String seq;
    int currentChannel;
    int currentSlice;
    int currentFrame;

    public ThumbnailsCanvas(ImagePlus imp) {
        this.iconWidth = this.iconSize = 100;
        this.iconHeight = this.iconSize;
        this.dx = 0;
        this.dy = 0;
        this.separatorY = 6;
        this.marginY = 10;
        this.marginX = 44;
        this.channelUnderCursor = 0;
        this.seq = "1234567890";
        if (!imp.isComposite()) {
            return;
        }
        this.cImp = (CompositeImage)imp;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.currentChannel = this.cImp.getChannel();
        this.currentSlice = this.cImp.getSlice();
        this.currentFrame = this.cImp.getFrame();
        this.channelUnderCursor = this.currentChannel;
        int ww = this.cImp.getWidth();
        int hh = this.cImp.getHeight();
        if (ww > hh) {
            this.iconHeight = this.iconWidth * hh / ww;
            this.dy = (this.iconWidth - this.iconHeight) / 2;
        }
        if (ww < hh) {
            this.iconWidth = this.iconHeight * ww / hh;
            this.dx = (this.iconHeight - this.iconWidth) / 2;
        }
        this.nChannels = this.cImp.getNChannels();
        this.seq = this.seq.substring(0, this.nChannels);
        this.setSize((this.nChannels + 1) * this.iconSize, 2 * this.iconSize + 30);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void setSequence(String seq) {
        this.seq = seq;
    }

    public int[] getStackPos() {
        return new int[]{this.currentChannel, this.currentSlice, this.currentFrame};
    }

    public void paint(Graphics g) {
        int y1;
        if (g == null) {
            return;
        }
        int savedMode = this.cImp.getMode();
        if (savedMode == 1) {
            this.cImp.setMode(2);
        }
        this.os = this.createImage((this.nChannels + 1) * this.iconSize, 2 * this.iconSize + 30);
        this.osg = this.os.getGraphics();
        this.osg.setFont(new Font("SansSerif", 0, 12));
        for (int chn = 1; chn <= this.nChannels; ++chn) {
            this.cImp.setPositionWithoutUpdate(chn, this.currentSlice, this.currentFrame);
            this.cImp.updateImage();
            ImageProcessor ipSmall = this.cImp.getProcessor().resize(this.iconWidth, this.iconHeight, true);
            BufferedImage bImg = ipSmall.getBufferedImage();
            int index = chn - 1;
            y1 = this.marginY;
            for (int row = 0; row < 2; ++row) {
                if (index >= 0) {
                    int xx = index * this.iconSize + this.marginX;
                    this.osg.drawImage(bImg, xx + this.dx, y1 + this.dy, null);
                    this.osg.setColor(Color.LIGHT_GRAY);
                    this.osg.drawRect(xx, y1, this.iconSize, this.iconSize);
                    this.osg.fillRoundRect(xx + this.iconSize / 2 - 4, y1 + this.iconSize - 22, 18, 18, 6, 6);
                    this.osg.setColor(Color.BLACK);
                    this.osg.drawRoundRect(xx + this.iconSize / 2 - 4, y1 + this.iconSize - 22, 18, 18, 6, 6);
                    this.osg.drawString("" + chn, xx + 52, y1 + this.iconSize - 7);
                    index = this.seq.indexOf("" + chn, 0);
                    if (this.seq.indexOf("" + chn, index) == -1) {
                        index = -1;
                    }
                }
                y1 += this.iconSize + this.separatorY;
            }
        }
        y1 = this.marginY + this.iconSize - 7;
        this.osg.drawString("Old:", 6, y1);
        this.osg.drawString("New:", 6, y1 += this.iconSize + this.separatorY);
        this.osg.dispose();
        if (this.os == null) {
            return;
        }
        g.drawImage(this.os, 0, 0, this);
        if (savedMode == 1) {
            this.cImp.setMode(savedMode);
        }
        this.cImp.setPosition(this.currentChannel, this.currentSlice, this.currentFrame);
        this.cImp.updateImage();
    }

    protected void handlePopupMenu(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        PopupMenu popup = new PopupMenu();
        String[] colors = "Grays,-,Red,Green,Blue,Yellow,Magenta,Cyan,-,Fire,Ice,Spectrum,3-3-2 RGB,Red/Green".split(",");
        for (int jj = 0; jj < colors.length; ++jj) {
            if (colors[jj].equals("-")) {
                popup.addSeparator();
                continue;
            }
            MenuItem mi = new MenuItem(colors[jj]);
            popup.add(mi);
            mi.addActionListener(this);
        }
        this.add(popup);
        if (IJ.isMacOSX()) {
            IJ.wait(10);
        }
        popup.show(this, x, y);
        this.setCursor(defaultCursor);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        this.cImp.setPosition(this.currentChannel, this.currentSlice, this.currentFrame);
        CompositeImage cImp = this.cImp;
        IJ.run(cmd);
        this.repaint();
        this.setCursor(defaultCursor);
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX() - this.marginX;
        int y = e.getY() - this.marginY;
        if (x < 0 || x > this.nChannels * this.iconSize || y < 0 || y > this.iconSize * 2 + this.separatorY) {
            this.setCursor(defaultCursor);
            this.channelUnderCursor = 0;
        } else {
            int chn = x / this.iconSize + 1;
            if (y > this.iconSize) {
                if (chn <= this.seq.length()) {
                    String digit = this.seq.substring(chn - 1, chn);
                    chn = "1234567890".indexOf(digit) + 1;
                } else {
                    chn = 0;
                }
            }
            if (y > 2 * this.iconSize + this.separatorY) {
                chn = 0;
            }
            this.channelUnderCursor = chn;
        }
        if (this.channelUnderCursor > 0) {
            this.setCursor(handCursor);
        } else {
            this.setCursor(defaultCursor);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (this.channelUnderCursor > 0) {
            this.currentChannel = this.channelUnderCursor;
            this.handlePopupMenu(e);
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }
}

