/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.plugin.PlugIn;
import ij.text.TextWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CommandFinder
implements PlugIn,
ActionListener,
WindowListener,
KeyListener,
ItemListener,
MouseListener {
    int multiClickInterval;
    long lastClickTime = Long.MIN_VALUE;
    String lastClickedItem;
    JFrame d;
    JTextField prompt;
    JList completions;
    JScrollPane scrollPane;
    DefaultListModel completionsModel;
    JButton runButton;
    JButton sourceButton;
    JButton closeButton;
    JButton exportButton;
    JCheckBox fullInfoCheckBox;
    JCheckBox closeCheckBox;
    Hashtable commandsHash;
    String[] commands;
    Hashtable listLabelToCommand;
    static boolean closeWhenRunning = Prefs.get("command-finder.close", true);

    public CommandFinder() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Integer interval = (Integer)toolkit.getDesktopProperty("awt.multiClickInterval");
        this.multiClickInterval = interval == null ? 300 : interval;
    }

    protected String makeListLabel(String command, CommandAction ca, boolean fullInfo) {
        if (fullInfo) {
            String jarFile;
            String result = command;
            if (ca.menuLocation != null) {
                result = result + " (in " + ca.menuLocation + ")";
            }
            if (ca.classCommand != null) {
                result = result + " [" + ca.classCommand + "]";
            }
            if ((jarFile = Menus.getJarFileForMenuEntry(command)) != null) {
                result = result + " {from " + jarFile + "}";
            }
            return result;
        }
        return command;
    }

    protected void populateList(String matchingSubstring) {
        boolean fullInfo = this.fullInfoCheckBox.isSelected();
        String substring = matchingSubstring.toLowerCase();
        this.completionsModel.removeAllElements();
        for (int i = 0; i < this.commands.length; ++i) {
            String lowerCommandName;
            String commandName = this.commands[i];
            if (commandName.length() == 0 || (lowerCommandName = commandName.toLowerCase()).indexOf(substring) < 0) continue;
            CommandAction ca = (CommandAction)this.commandsHash.get(commandName);
            String listLabel = this.makeListLabel(commandName, ca, fullInfo);
            this.completionsModel.addElement(listLabel);
        }
        this.prompt.requestFocus();
    }

    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.runButton) {
            String selected = (String)this.completions.getSelectedValue();
            if (selected == null) {
                IJ.error("Please select a command to run");
                return;
            }
            this.runFromLabel(selected);
        } else if (source == this.sourceButton) {
            String selected = (String)this.completions.getSelectedValue();
            if (selected == null) {
                IJ.error("Please select a command");
                return;
            }
            this.showSource(selected);
        } else if (source == this.exportButton) {
            this.export();
        } else if (source == this.closeButton) {
            this.d.dispose();
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        this.populateList(this.prompt.getText());
    }

    public void mouseClicked(MouseEvent e) {
        long now = System.currentTimeMillis();
        String justClickedItem = (String)this.completions.getSelectedValue();
        long thisClickInterval = now - this.lastClickTime;
        if (thisClickInterval < (long)this.multiClickInterval && justClickedItem != null && this.lastClickedItem != null && justClickedItem.equals(this.lastClickedItem)) {
            this.runFromLabel(justClickedItem);
        }
        this.lastClickTime = now;
        this.lastClickedItem = justClickedItem;
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    void showSource(String cmd) {
        int openParen;
        cmd = (String)this.listLabelToCommand.get(cmd);
        Hashtable table = Menus.getCommands();
        String className = (String)table.get(cmd);
        if (IJ.debugMode) {
            IJ.log("showSource: " + cmd + "   " + className);
        }
        if (className == null) {
            IJ.error("No source associated with this command:\n  " + cmd);
            return;
        }
        int mstart = className.indexOf("ij.plugin.Macro_Runner(\"");
        if (mstart >= 0) {
            int mend = className.indexOf("\")");
            if (mend == -1) {
                return;
            }
            String macro = className.substring(mstart + 24, mend);
            IJ.open(IJ.getDirectory("plugins") + macro);
            return;
        }
        if (className.endsWith("\")") && (openParen = className.lastIndexOf("(\"")) > 0) {
            className = className.substring(0, openParen);
        }
        if (className.startsWith("ij.")) {
            className = className.replaceAll("\\.", "/");
            IJ.runPlugIn("ij.plugin.BrowserLauncher", "http://imagej.nih.gov/ij/source/" + className + ".java");
            return;
        }
        className = IJ.getDirectory("plugins") + className.replaceAll("\\.", "/");
        String path = className + ".java";
        File f = new File(path);
        if (f.exists()) {
            IJ.open(path);
            return;
        }
        IJ.error("Unable to display source for this plugin:\n  " + className);
    }

    void export() {
        StringBuffer sb = new StringBuffer(5000);
        for (int i = 0; i < this.completionsModel.size(); ++i) {
            sb.append(i);
            sb.append("\t");
            sb.append((String)this.completionsModel.elementAt(i));
            sb.append("\n");
        }
        TextWindow tw = new TextWindow("ImageJ Menu Commands", " \tCommand", sb.toString(), 600, 500);
    }

    protected void runFromLabel(String listLabel) {
        String command = (String)this.listLabelToCommand.get(listLabel);
        CommandAction ca = (CommandAction)this.commandsHash.get(command);
        IJ.showStatus("Running command " + ca.classCommand);
        IJ.doCommand(command);
        closeWhenRunning = this.closeCheckBox.isSelected();
        if (closeWhenRunning) {
            this.d.dispose();
        }
    }

    public void keyPressed(KeyEvent ke) {
        boolean meta;
        int key = ke.getKeyCode();
        int flags = ke.getModifiers();
        int items = this.completionsModel.getSize();
        Object source = ke.getSource();
        boolean bl = meta = (flags & 4) != 0 || (flags & 2) != 0;
        if (key == 27 || key == 87 && meta) {
            this.d.dispose();
        } else if (source == this.prompt) {
            if (key == 10 && 1 == items) {
                String selected = (String)this.completionsModel.elementAt(0);
                this.runFromLabel(selected);
            }
            int index = -1;
            if (key == 38) {
                index = this.completions.getSelectedIndex() - 1;
                if (index < 0) {
                    index = items - 1;
                }
            } else if (key == 40) {
                index = this.completions.getSelectedIndex() + 1;
                if (index >= items) {
                    index = Math.min(items - 1, 0);
                }
            } else if (key == 34) {
                index = this.completions.getLastVisibleIndex();
            }
            if (index >= 0) {
                this.completions.requestFocus();
                this.completions.ensureIndexIsVisible(index);
                this.completions.setSelectedIndex(index);
            }
        } else if (key == 8) {
            this.prompt.requestFocus();
        } else if (source == this.completions) {
            if (key == 10) {
                String selected = (String)this.completions.getSelectedValue();
                if (selected != null) {
                    this.runFromLabel(selected);
                }
            } else if (key == 38) {
                if (this.completions.getSelectedIndex() <= 0) {
                    this.completions.clearSelection();
                    this.prompt.requestFocus();
                }
            } else if (key == 40 && this.completions.getSelectedIndex() == items - 1) {
                this.completions.clearSelection();
                this.prompt.requestFocus();
            }
        } else if (source == this.runButton) {
            String selected;
            if (key == 10 && (selected = (String)this.completions.getSelectedValue()) != null) {
                this.runFromLabel(selected);
            }
        } else if (source == this.closeButton && key == 10) {
            this.d.dispose();
        }
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void parseMenu(String path, Menu menu) {
        int n = menu.getItemCount();
        for (int i = 0; i < n; ++i) {
            MenuItem m = menu.getItem(i);
            String label = m.getLabel();
            if (m instanceof Menu) {
                Menu subMenu = (Menu)m;
                this.parseMenu(path + " > " + label, subMenu);
                continue;
            }
            String trimmedLabel = label.trim();
            if (trimmedLabel.length() == 0 || trimmedLabel.equals("-")) continue;
            CommandAction ca = (CommandAction)this.commandsHash.get(label);
            if (ca == null) {
                this.commandsHash.put(label, new CommandAction(null, m, path));
            } else {
                ca.menuItem = m;
                ca.menuLocation = path;
            }
            CommandAction caAfter = (CommandAction)this.commandsHash.get(label);
        }
    }

    public void findAllMenuItems() {
        MenuBar menuBar = Menus.getMenuBar();
        int topLevelMenus = menuBar.getMenuCount();
        for (int i = 0; i < topLevelMenus; ++i) {
            Menu topLevelMenu = menuBar.getMenu(i);
            this.parseMenu(topLevelMenu.getLabel(), topLevelMenu);
        }
    }

    public void run(String ignored) {
        this.commandsHash = new Hashtable();
        Hashtable realCommandsHash = (Hashtable)Menus.getCommands().clone();
        Set realCommandSet = realCommandsHash.keySet();
        for (String command : realCommandSet) {
            String trimmedCommand = command.trim();
            if (trimmedCommand.length() <= 0 || trimmedCommand.equals("-")) continue;
            this.commandsHash.put(command, new CommandAction((String)realCommandsHash.get(command), null, null));
        }
        this.findAllMenuItems();
        this.commands = this.commandsHash.keySet().toArray(new String[0]);
        Arrays.sort(this.commands);
        this.listLabelToCommand = new Hashtable();
        for (int i = 0; i < this.commands.length; ++i) {
            CommandAction ca = (CommandAction)this.commandsHash.get(this.commands[i]);
            this.listLabelToCommand.put(this.makeListLabel(this.commands[i], ca, true), this.commands[i]);
            this.listLabelToCommand.put(this.makeListLabel(this.commands[i], ca, false), this.commands[i]);
        }
        ImageJ imageJ = IJ.getInstance();
        this.d = new JFrame("Command Finder"){

            public void setVisible(boolean visible) {
                if (visible) {
                    WindowManager.addWindow(this);
                }
                super.setVisible(visible);
            }

            public void dispose() {
                WindowManager.removeWindow(this);
                super.dispose();
            }
        };
        Container contentPane = this.d.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.d.addWindowListener(this);
        this.fullInfoCheckBox = new JCheckBox("Show full information", false);
        this.fullInfoCheckBox.addItemListener(this);
        this.closeCheckBox = new JCheckBox("Close when running", closeWhenRunning);
        this.closeCheckBox.addItemListener(this);
        JPanel northPanel = new JPanel();
        northPanel.add(new JLabel("Type part of a command:"));
        this.prompt = new JTextField("", 30);
        this.prompt.getDocument().addDocumentListener(new PromptDocumentListener());
        this.prompt.addKeyListener(this);
        northPanel.add(this.prompt);
        contentPane.add((Component)northPanel, "North");
        this.completionsModel = new DefaultListModel();
        this.completions = new JList(this.completionsModel);
        this.scrollPane = new JScrollPane(this.completions);
        this.completions.setSelectionMode(0);
        this.completions.setLayoutOrientation(0);
        this.completions.setVisibleRowCount(20);
        this.completions.addKeyListener(this);
        this.populateList("");
        contentPane.add((Component)this.scrollPane, "Center");
        this.completions.addMouseListener(this);
        this.runButton = new JButton("Run");
        this.sourceButton = new JButton("Source");
        this.exportButton = new JButton("Export");
        this.closeButton = new JButton("Close");
        this.runButton.addActionListener(this);
        this.sourceButton.addActionListener(this);
        this.exportButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.runButton.addKeyListener(this);
        this.sourceButton.addKeyListener(this);
        this.closeButton.addKeyListener(this);
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BorderLayout());
        JPanel optionsPanel = new JPanel();
        optionsPanel.add(this.fullInfoCheckBox);
        optionsPanel.add(this.closeCheckBox);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.runButton);
        buttonsPanel.add(this.sourceButton);
        buttonsPanel.add(this.exportButton);
        buttonsPanel.add(this.closeButton);
        southPanel.add((Component)optionsPanel, "Center");
        southPanel.add((Component)buttonsPanel, "South");
        contentPane.add((Component)southPanel, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.d.pack();
        int dialogWidth = this.d.getWidth();
        int dialogHeight = this.d.getHeight();
        int screenWidth = (int)screenSize.getWidth();
        int screenHeight = (int)screenSize.getHeight();
        Point pos = imageJ.getLocationOnScreen();
        int initialX = (int)pos.getX() + 38;
        int initialY = (int)pos.getY() + 84;
        if (initialX + dialogWidth > screenWidth) {
            initialX = screenWidth - dialogWidth;
        }
        if (initialX < 0) {
            initialX = 0;
        }
        if (initialY + dialogHeight > screenHeight) {
            initialY = screenHeight - dialogHeight;
        }
        if (initialY < 0) {
            initialY = 0;
        }
        this.d.setLocation(initialX, initialY);
        this.d.setVisible(true);
        this.d.toFront();
    }

    public void windowClosing(WindowEvent e) {
        this.d.dispose();
        Prefs.set("command-finder.close", closeWhenRunning);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    class PromptDocumentListener
    implements DocumentListener {
        PromptDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            CommandFinder.this.populateList(CommandFinder.this.prompt.getText());
        }

        public void removeUpdate(DocumentEvent e) {
            CommandFinder.this.populateList(CommandFinder.this.prompt.getText());
        }

        public void changedUpdate(DocumentEvent e) {
            CommandFinder.this.populateList(CommandFinder.this.prompt.getText());
        }
    }

    private static class LevenshteinPair
    implements Comparable {
        int index;
        int cost;

        LevenshteinPair(int index, int cost) {
            this.index = index;
            this.cost = cost;
        }

        public int compareTo(Object o) {
            return this.cost - ((LevenshteinPair)o).cost;
        }
    }

    class CommandAction {
        String classCommand;
        MenuItem menuItem;
        String menuLocation;

        CommandAction(String classCommand, MenuItem menuItem, String menuLocation) {
            this.classCommand = classCommand;
            this.menuItem = menuItem;
            this.menuLocation = menuLocation;
        }

        public String toString() {
            return "classCommand: " + this.classCommand + ", menuItem: " + this.menuItem + ", menuLocation: " + this.menuLocation;
        }
    }
}

