/*
 * Decompiled with CFR 0.152.
 */
package non_com.media.jai.codec.jpeg;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGQTable;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import non_com.media.jai.codec.ImageEncodeParam;
import non_com.media.jai.codec.ImageEncoderImpl;
import non_com.media.jai.codec.JaiI18N;
import non_com.media.jai.codec.jpeg.JPEGEncodeParam;

public class JPEGImageEncoder
extends ImageEncoderImpl {
    private JPEGEncodeParam jaiEP = null;

    public JPEGImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (imageEncodeParam != null) {
            this.jaiEP = (JPEGEncodeParam)imageEncodeParam;
        }
    }

    public static void modifyEncodeParam(JPEGEncodeParam jPEGEncodeParam, com.sun.image.codec.jpeg.JPEGEncodeParam jPEGEncodeParam2, int n) {
        int n2;
        for (int i = 0; i < n; ++i) {
            n2 = jPEGEncodeParam.getHorizontalSubsampling(i);
            jPEGEncodeParam2.setHorizontalSubsampling(i, n2);
            n2 = jPEGEncodeParam.getVerticalSubsampling(i);
            jPEGEncodeParam2.setVerticalSubsampling(i, n2);
            if (!jPEGEncodeParam.isQTableSet(i)) continue;
            int[] nArray = jPEGEncodeParam.getQTable(i);
            n2 = jPEGEncodeParam.getQTableSlot(i);
            jPEGEncodeParam2.setQTableComponentMapping(i, n2);
            jPEGEncodeParam2.setQTable(n2, new JPEGQTable(nArray));
        }
        if (jPEGEncodeParam.isQualitySet()) {
            float f = jPEGEncodeParam.getQuality();
            jPEGEncodeParam2.setQuality(f, true);
        }
        n2 = jPEGEncodeParam.getRestartInterval();
        jPEGEncodeParam2.setRestartInterval(n2);
        if (jPEGEncodeParam.getWriteTablesOnly()) {
            jPEGEncodeParam2.setImageInfoValid(false);
            jPEGEncodeParam2.setTableInfoValid(true);
        }
        if (jPEGEncodeParam.getWriteImageOnly()) {
            jPEGEncodeParam2.setTableInfoValid(false);
            jPEGEncodeParam2.setImageInfoValid(true);
        }
        if (!jPEGEncodeParam.getWriteJFIFHeader()) {
            jPEGEncodeParam2.setMarkerData(224, (byte[][])null);
        }
        jPEGEncodeParam2.setMarkerData(224, (byte[][])null);
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        BufferedImage bufferedImage;
        IndexColorModel indexColorModel;
        SampleModel sampleModel = renderedImage.getSampleModel();
        ColorModel colorModel = renderedImage.getColorModel();
        int n = colorModel.getNumColorComponents();
        int n2 = sampleModel.getTransferType();
        if (n2 != 0 || n != 1 && n != 3) {
            throw new RuntimeException(JaiI18N.getString("JPEGImageEncoder0"));
        }
        int n3 = colorModel.getColorSpace().getType();
        if (n3 != 6 && n3 != 5) {
            throw new Error(JaiI18N.getString("JPEGImageEncoder1"));
        }
        WritableRaster writableRaster = (WritableRaster)renderedImage.getData();
        if (writableRaster.getMinX() != 0 || writableRaster.getMinY() != 0) {
            writableRaster = writableRaster.createWritableTranslatedChild(0, 0);
        }
        com.sun.image.codec.jpeg.JPEGEncodeParam jPEGEncodeParam = null;
        if (colorModel instanceof IndexColorModel) {
            indexColorModel = (IndexColorModel)colorModel;
            bufferedImage = indexColorModel.convertToIntDiscrete(writableRaster, false);
            jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
        } else {
            bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
            jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
        }
        if (this.jaiEP != null) {
            JPEGImageEncoder.modifyEncodeParam(this.jaiEP, jPEGEncodeParam, n);
        }
        indexColorModel = JPEGCodec.createJPEGEncoder((OutputStream)this.output, (com.sun.image.codec.jpeg.JPEGEncodeParam)jPEGEncodeParam);
        try {
            indexColorModel.encode(bufferedImage);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }
}

