/*
 * Decompiled with CFR 0.152.
 */
package non_com.media.jai.codec;

import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import non_com.media.jai.codec.ForwardSeekableStream;
import non_com.media.jai.codec.ImageCodec;
import non_com.media.jai.codec.ImageDecodeParam;
import non_com.media.jai.codec.ImageDecoder;
import non_com.media.jai.codec.ImageEncodeParam;
import non_com.media.jai.codec.ImageEncoder;
import non_com.media.jai.codec.PNMEncodeParam;
import non_com.media.jai.codec.PNMImageDecoder;
import non_com.media.jai.codec.PNMImageEncoder;
import non_com.media.jai.codec.SeekableStream;

public final class PNMCodec
extends ImageCodec {
    static /* synthetic */ Class class$non_com$media$jai$codec$PNMEncodeParam;
    static /* synthetic */ Class class$java$lang$Object;

    public String getFormatName() {
        return "pnm";
    }

    public Class getEncodeParamClass() {
        return class$non_com$media$jai$codec$PNMEncodeParam == null ? (class$non_com$media$jai$codec$PNMEncodeParam = PNMCodec.class$("non_com.media.jai.codec.PNMEncodeParam")) : class$non_com$media$jai$codec$PNMEncodeParam;
    }

    public Class getDecodeParamClass() {
        return class$java$lang$Object == null ? (class$java$lang$Object = PNMCodec.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public int getNumHeaderBytes() {
        return 2;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == 80 && byArray[1] >= 49 && byArray[1] <= 54;
    }

    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getTransferType();
        if (n == 4 || n == 5) {
            return false;
        }
        int n2 = sampleModel.getNumBands();
        return n2 == 1 || n2 == 3;
    }

    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        PNMEncodeParam pNMEncodeParam = null;
        if (imageEncodeParam != null) {
            pNMEncodeParam = (PNMEncodeParam)imageEncodeParam;
        }
        return new PNMImageEncoder(outputStream, pNMEncodeParam);
    }

    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        return new PNMImageDecoder(new ForwardSeekableStream(inputStream), null);
    }

    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new PNMImageDecoder(seekableStream, null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

