/*
 * Decompiled with CFR 0.152.
 */
package non_com.media.jai.codec;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Date;
import java.util.Vector;
import non_com.media.jai.codec.ImageEncodeParam;
import non_com.media.jai.codec.JaiI18N;
import non_com.media.jai.codec.PNGSuggestedPaletteEntry;

public abstract class PNGEncodeParam
implements ImageEncodeParam {
    public static final int INTENT_PERCEPTUAL = 0;
    public static final int INTENT_RELATIVE = 1;
    public static final int INTENT_SATURATION = 2;
    public static final int INTENT_ABSOLUTE = 3;
    public static final int PNG_FILTER_NONE = 0;
    public static final int PNG_FILTER_SUB = 1;
    public static final int PNG_FILTER_UP = 2;
    public static final int PNG_FILTER_AVERAGE = 3;
    public static final int PNG_FILTER_PAETH = 4;
    protected int bitDepth;
    protected boolean bitDepthSet = false;
    boolean transparencySet = false;
    Vector chunkType = new Vector();
    Vector chunkData = new Vector();
    private boolean useInterlacing = false;
    private float[] chromaticity = null;
    private boolean chromaticitySet = false;
    private float gamma;
    private boolean gammaSet = false;
    private int[] paletteHistogram = null;
    private boolean paletteHistogramSet = false;
    private byte[] ICCProfileData = null;
    private boolean ICCProfileDataSet = false;
    private int[] physicalDimension = null;
    private boolean physicalDimensionSet = false;
    private PNGSuggestedPaletteEntry[] suggestedPalette = null;
    private boolean suggestedPaletteSet = false;
    private int[] significantBits = null;
    private boolean significantBitsSet = false;
    private int SRGBIntent;
    private boolean SRGBIntentSet = false;
    private String[] text = null;
    private boolean textSet = false;
    private Date modificationTime;
    private boolean modificationTimeSet = false;
    private String[] zText = null;
    private boolean zTextSet = false;

    public static PNGEncodeParam getDefaultEncodeParam(RenderedImage renderedImage) {
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            return new Palette();
        }
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getNumBands();
        if (n == 1 || n == 2) {
            return new Gray();
        }
        return new RGB();
    }

    public static final int paethPredictor(int n, int n2, int n3) {
        int n4 = n + n2 - n3;
        int n5 = PNGEncodeParam.abs(n4 - n);
        int n6 = PNGEncodeParam.abs(n4 - n2);
        int n7 = PNGEncodeParam.abs(n4 - n3);
        if (n5 <= n6 && n5 <= n7) {
            return n;
        }
        if (n6 <= n7) {
            return n2;
        }
        return n3;
    }

    private static final int abs(int n) {
        return n < 0 ? -n : n;
    }

    public abstract void setBitDepth(int var1);

    public void setInterlacing(boolean bl) {
        this.useInterlacing = bl;
    }

    public void setChromaticity(float[] fArray) {
        if (fArray.length != 8) {
            throw new IllegalArgumentException();
        }
        this.chromaticity = (float[])fArray.clone();
        this.chromaticitySet = true;
    }

    public void setChromaticity(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float[] fArray = new float[]{f, f2, f3, f4, f5, f6, f7, f8};
        this.setChromaticity(fArray);
    }

    public void setGamma(float f) {
        this.gamma = f;
        this.gammaSet = true;
    }

    public void setPaletteHistogram(int[] nArray) {
        this.paletteHistogram = (int[])nArray.clone();
        this.paletteHistogramSet = true;
    }

    public void setICCProfileData(byte[] byArray) {
        this.ICCProfileData = (byte[])byArray.clone();
        this.ICCProfileDataSet = true;
    }

    public void setPhysicalDimension(int[] nArray) {
        this.physicalDimension = (int[])nArray.clone();
        this.physicalDimensionSet = true;
    }

    public void setPhysicalDimension(int n, int n2, int n3) {
        int[] nArray = new int[]{n, n2, n3};
        this.setPhysicalDimension(nArray);
    }

    public void setSuggestedPalette(PNGSuggestedPaletteEntry[] pNGSuggestedPaletteEntryArray) {
        this.suggestedPalette = (PNGSuggestedPaletteEntry[])pNGSuggestedPaletteEntryArray.clone();
        this.suggestedPaletteSet = true;
    }

    public void setSignificantBits(int[] nArray) {
        this.significantBits = (int[])nArray.clone();
        this.significantBitsSet = true;
    }

    public void setSRGBIntent(int n) {
        this.SRGBIntent = n;
        this.SRGBIntentSet = true;
    }

    public void setText(String[] stringArray) {
        this.text = stringArray;
        this.textSet = true;
    }

    public void setModificationTime(Date date) {
        this.modificationTime = date;
        this.modificationTimeSet = true;
    }

    public void setCompressedText(String[] stringArray) {
        this.zText = stringArray;
        this.zTextSet = true;
    }

    public int getBitDepth() {
        if (!this.bitDepthSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam11"));
        }
        return this.bitDepth;
    }

    public boolean getInterlacing() {
        return this.useInterlacing;
    }

    public boolean isBackgroundSet() {
        throw new RuntimeException(JaiI18N.getString("PNGEncodeParam24"));
    }

    public float[] getChromaticity() {
        if (!this.chromaticitySet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam12"));
        }
        return (float[])this.chromaticity.clone();
    }

    public boolean isChromaticitySet() {
        return this.chromaticitySet;
    }

    public float getGamma() {
        if (!this.gammaSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam13"));
        }
        return this.gamma;
    }

    public boolean isGammaSet() {
        return this.gammaSet;
    }

    public int[] getPaletteHistogram() {
        if (!this.paletteHistogramSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam14"));
        }
        return this.paletteHistogram;
    }

    public boolean isPaletteHistogramSet() {
        return this.paletteHistogramSet;
    }

    public byte[] getICCProfileData() {
        if (!this.ICCProfileDataSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam15"));
        }
        return (byte[])this.ICCProfileData.clone();
    }

    public boolean isICCProfileDataSet() {
        return this.ICCProfileDataSet;
    }

    public int[] getPhysicalDimension() {
        if (!this.physicalDimensionSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam16"));
        }
        return (int[])this.physicalDimension.clone();
    }

    public boolean isPhysicalDimensionSet() {
        return this.physicalDimensionSet;
    }

    public PNGSuggestedPaletteEntry[] getSuggestedPalette() {
        if (!this.suggestedPaletteSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam17"));
        }
        return (PNGSuggestedPaletteEntry[])this.suggestedPalette.clone();
    }

    public boolean isSuggestedPaletteSet() {
        return this.suggestedPaletteSet;
    }

    public int[] getSignificantBits() {
        if (!this.significantBitsSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam18"));
        }
        return (int[])this.significantBits.clone();
    }

    public boolean isSignificantBitsSet() {
        return this.significantBitsSet;
    }

    public int getSRGBIntent() {
        if (!this.SRGBIntentSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam19"));
        }
        return this.SRGBIntent;
    }

    public boolean isSRGBIntentSet() {
        return this.SRGBIntentSet;
    }

    public String[] getText() {
        if (!this.textSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam20"));
        }
        return this.text;
    }

    public boolean isTextSet() {
        return this.textSet;
    }

    public Date getModificationTime() {
        if (!this.modificationTimeSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam21"));
        }
        return this.modificationTime;
    }

    public boolean isModificationTimeSet() {
        return this.modificationTimeSet;
    }

    public boolean isTransparencySet() {
        return this.transparencySet;
    }

    public String[] getCompressedText() {
        if (!this.zTextSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam22"));
        }
        return this.zText;
    }

    public boolean isCompressedTextSet() {
        return this.zTextSet;
    }

    public synchronized int getNumPrivateChunks() {
        return this.chunkType.size();
    }

    public synchronized String getPrivateChunkType(int n) {
        return (String)this.chunkType.elementAt(n);
    }

    public synchronized byte[] getPrivateChunkData(int n) {
        return (byte[])this.chunkData.elementAt(n);
    }

    public void unsetBitDepth() {
        this.bitDepthSet = false;
    }

    public void unsetBackground() {
        throw new RuntimeException(JaiI18N.getString("PNGEncodeParam23"));
    }

    public void unsetChromaticity() {
        this.chromaticity = null;
        this.chromaticitySet = false;
    }

    public void unsetGamma() {
        this.gammaSet = false;
    }

    public void unsetPaletteHistogram() {
        this.paletteHistogram = null;
        this.paletteHistogramSet = false;
    }

    public void unsetICCProfileData() {
        this.ICCProfileData = null;
        this.ICCProfileDataSet = false;
    }

    public void unsetPhysicalDimension() {
        this.physicalDimension = null;
        this.physicalDimensionSet = false;
    }

    public void unsetSuggestedPalette() {
        this.suggestedPalette = null;
        this.suggestedPaletteSet = false;
    }

    public void unsetSignificantBits() {
        this.significantBits = null;
        this.significantBitsSet = false;
    }

    public void unsetSRGBIntent() {
        this.SRGBIntentSet = false;
    }

    public void unsetText() {
        this.text = null;
        this.textSet = false;
    }

    public void unsetModificationTime() {
        this.modificationTime = null;
        this.modificationTimeSet = false;
    }

    public void unsetTransparency() {
        this.transparencySet = false;
    }

    public void unsetCompressedText() {
        this.zText = null;
        this.zTextSet = false;
    }

    public synchronized void addPrivateChunk(String string, byte[] byArray) {
        this.chunkType.add(string);
        this.chunkData.add((byte[])byArray.clone());
    }

    public synchronized void removeUnsafeToCopyPrivateChunks() {
        Vector<String> vector = new Vector<String>();
        Vector<byte[]> vector2 = new Vector<byte[]>();
        int n = this.getNumPrivateChunks();
        for (int i = 0; i < n; ++i) {
            String string = this.getPrivateChunkType(i);
            char c = string.charAt(3);
            if (c < 'a' || c > 'z') continue;
            vector.add(string);
            vector2.add(this.getPrivateChunkData(i));
        }
        this.chunkType = vector;
        this.chunkData = vector2;
    }

    public synchronized void removeAllPrivateChunks() {
        this.chunkType = new Vector();
        this.chunkData = new Vector();
    }

    public int filterRow(byte[] byArray, byte[] byArray2, byte[][] byArray3, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int[] nArray = new int[5];
        for (n9 = 0; n9 < 5; ++n9) {
            nArray[n9] = Integer.MAX_VALUE;
        }
        n9 = 0;
        for (n8 = n2; n8 < n + n2; ++n8) {
            n7 = byArray[n8] & 0xFF;
            n9 += n7;
        }
        nArray[0] = n9;
        byte[] byArray4 = byArray3[1];
        n8 = 0;
        for (n7 = n2; n7 < n + n2; ++n7) {
            n6 = byArray[n7] & 0xFF;
            n5 = byArray[n7 - n2] & 0xFF;
            n4 = n6 - n5;
            byArray4[n7] = (byte)n4;
            n8 += PNGEncodeParam.abs(n4);
        }
        nArray[1] = n8;
        byArray4 = byArray3[2];
        n8 = 0;
        for (n7 = n2; n7 < n + n2; ++n7) {
            n6 = byArray[n7] & 0xFF;
            n5 = byArray2[n7] & 0xFF;
            n4 = n6 - n5;
            byArray4[n7] = (byte)n4;
            n8 += PNGEncodeParam.abs(n4);
        }
        nArray[2] = n8;
        byArray4 = byArray3[3];
        n8 = 0;
        for (n7 = n2; n7 < n + n2; ++n7) {
            n6 = byArray[n7] & 0xFF;
            n5 = byArray[n7 - n2] & 0xFF;
            n4 = byArray2[n7] & 0xFF;
            n3 = n6 - (n5 + n4) / 2;
            byArray4[n7] = (byte)n3;
            n8 += PNGEncodeParam.abs(n3);
        }
        nArray[3] = n8;
        byArray4 = byArray3[4];
        n8 = 0;
        for (n7 = n2; n7 < n + n2; ++n7) {
            n6 = byArray[n7] & 0xFF;
            n5 = byArray[n7 - n2] & 0xFF;
            n4 = byArray2[n7] & 0xFF;
            n3 = byArray2[n7 - n2] & 0xFF;
            int n10 = PNGEncodeParam.paethPredictor(n5, n4, n3);
            int n11 = n6 - n10;
            byArray4[n7] = (byte)n11;
            n8 += PNGEncodeParam.abs(n11);
        }
        nArray[4] = n8;
        int n12 = 0;
        n8 = nArray[0];
        for (n7 = 1; n7 < 5; ++n7) {
            if (nArray[n7] >= n8) continue;
            n8 = nArray[n7];
            n12 = n7;
        }
        if (n12 == 0) {
            System.arraycopy(byArray, n2, byArray3[0], n2, n);
        }
        return n12;
    }

    public static class RGB
    extends PNGEncodeParam {
        private boolean backgroundSet = false;
        private int[] backgroundRGB;
        private int[] transparency;

        public void setBitDepth(int n) {
            if (n != 8 && n != 16) {
                throw new RuntimeException();
            }
            this.bitDepth = n;
            this.bitDepthSet = true;
        }

        public void setBackgroundRGB(int[] nArray) {
            if (nArray.length != 3) {
                throw new RuntimeException();
            }
            this.backgroundRGB = nArray;
            this.backgroundSet = true;
        }

        public void setTransparentRGB(int[] nArray) {
            this.transparency = (int[])nArray.clone();
            this.transparencySet = true;
        }

        public boolean isBackgroundSet() {
            return this.backgroundSet;
        }

        public int[] getBackgroundRGB() {
            if (!this.backgroundSet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam9"));
            }
            return this.backgroundRGB;
        }

        public int[] getTransparentRGB() {
            if (!this.transparencySet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam10"));
            }
            return (int[])this.transparency.clone();
        }

        public void unsetBackground() {
            this.backgroundSet = false;
        }
    }

    public static class Gray
    extends PNGEncodeParam {
        private boolean backgroundSet = false;
        private int backgroundPaletteGray;
        private int[] transparency;
        private int bitShift;
        private boolean bitShiftSet = false;

        public void setBitDepth(int n) {
            if (n != 1 && n != 2 && n != 4 && n != 8 && n != 16) {
                throw new IllegalArgumentException();
            }
            this.bitDepth = n;
            this.bitDepthSet = true;
        }

        public void setBackgroundGray(int n) {
            this.backgroundPaletteGray = n;
            this.backgroundSet = true;
        }

        public void setTransparentGray(int n) {
            this.transparency = new int[1];
            this.transparency[0] = n;
            this.transparencySet = true;
        }

        public void setBitShift(int n) {
            if (n < 0) {
                throw new RuntimeException();
            }
            this.bitShift = n;
            this.bitShiftSet = true;
        }

        public boolean isBackgroundSet() {
            return this.backgroundSet;
        }

        public int getBackgroundGray() {
            if (!this.backgroundSet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam6"));
            }
            return this.backgroundPaletteGray;
        }

        public int getTransparentGray() {
            if (!this.transparencySet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam7"));
            }
            int n = this.transparency[0];
            return n;
        }

        public int getBitShift() {
            if (!this.bitShiftSet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam8"));
            }
            return this.bitShift;
        }

        public boolean isBitShiftSet() {
            return this.bitShiftSet;
        }

        public boolean isBitDepthSet() {
            return this.bitDepthSet;
        }

        public void unsetBackground() {
            this.backgroundSet = false;
        }

        public void unsetBitShift() {
            this.bitShiftSet = false;
        }
    }

    public static class Palette
    extends PNGEncodeParam {
        private boolean backgroundSet = false;
        private int[] palette = null;
        private boolean paletteSet = false;
        private int backgroundPaletteIndex;
        private int[] transparency;

        public void setBitDepth(int n) {
            if (n != 1 && n != 2 && n != 4 && n != 8) {
                throw new IllegalArgumentException(JaiI18N.getString("PNGEncodeParam2"));
            }
            this.bitDepth = n;
            this.bitDepthSet = true;
        }

        public void setPalette(int[] nArray) {
            if (nArray.length < 3 || nArray.length > 768) {
                throw new IllegalArgumentException(JaiI18N.getString("PNGEncodeParam0"));
            }
            if (nArray.length % 3 != 0) {
                throw new IllegalArgumentException(JaiI18N.getString("PNGEncodeParam1"));
            }
            this.palette = (int[])nArray.clone();
            this.paletteSet = true;
        }

        public void setBackgroundPaletteIndex(int n) {
            this.backgroundPaletteIndex = n;
            this.backgroundSet = true;
        }

        public void setPaletteTransparency(byte[] byArray) {
            this.transparency = new int[byArray.length];
            for (int i = 0; i < byArray.length; ++i) {
                this.transparency[i] = byArray[i] & 0xFF;
            }
            this.transparencySet = true;
        }

        public boolean isBackgroundSet() {
            return this.backgroundSet;
        }

        public int[] getPalette() {
            if (!this.paletteSet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam3"));
            }
            return (int[])this.palette.clone();
        }

        public boolean isPaletteSet() {
            return this.paletteSet;
        }

        public int getBackgroundPaletteIndex() {
            if (!this.backgroundSet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam4"));
            }
            return this.backgroundPaletteIndex;
        }

        public byte[] getPaletteTransparency() {
            if (!this.transparencySet) {
                throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam5"));
            }
            byte[] byArray = new byte[this.transparency.length];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)this.transparency[i];
            }
            return byArray;
        }

        public void unsetBackground() {
            this.backgroundSet = false;
        }

        public void unsetPalette() {
            this.palette = null;
            this.paletteSet = false;
        }
    }
}

