/*
 * Decompiled with CFR 0.152.
 */
package non_com.media.jai.codec;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import non_com.media.jai.FloatDoubleColorModel;
import non_com.media.jai.codec.BMPCodec;
import non_com.media.jai.codec.FPXCodec;
import non_com.media.jai.codec.FileSeekableStream;
import non_com.media.jai.codec.GIFCodec;
import non_com.media.jai.codec.ImageDecodeParam;
import non_com.media.jai.codec.ImageDecoder;
import non_com.media.jai.codec.ImageEncodeParam;
import non_com.media.jai.codec.ImageEncoder;
import non_com.media.jai.codec.JaiI18N;
import non_com.media.jai.codec.PNGCodec;
import non_com.media.jai.codec.PNMCodec;
import non_com.media.jai.codec.SeekableStream;
import non_com.media.jai.codec.TIFFCodec;
import non_com.media.jai.codec.jpeg.JPEGCodec;

public abstract class ImageCodec {
    private static Hashtable codecs = new Hashtable();
    private static final byte[][] grayIndexCmaps = new byte[][]{null, {0, -1}, {0, 85, -86, -1}, null, {0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1}};
    private static final int[] GrayBits8 = new int[]{8};
    private static final ComponentColorModel colorModelGray8 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayBits8, false, false, 1, 0);
    private static final int[] GrayAlphaBits8 = new int[]{8, 8};
    private static final ComponentColorModel colorModelGrayAlpha8 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayAlphaBits8, true, false, 3, 0);
    private static final int[] GrayBits16 = new int[]{16};
    private static final ComponentColorModel colorModelGray16 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayBits16, false, false, 1, 1);
    private static final int[] GrayAlphaBits16 = new int[]{16, 16};
    private static final ComponentColorModel colorModelGrayAlpha16 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayAlphaBits16, true, false, 3, 1);
    private static final int[] GrayBits32 = new int[]{32};
    private static final ComponentColorModel colorModelGray32 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayBits32, false, false, 1, 3);
    private static final int[] GrayAlphaBits32 = new int[]{32, 32};
    private static final ComponentColorModel colorModelGrayAlpha32 = new ComponentColorModel(ColorSpace.getInstance(1003), GrayAlphaBits32, true, false, 3, 3);
    private static final int[] RGBBits8 = new int[]{8, 8, 8};
    private static final ComponentColorModel colorModelRGB8 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits8, false, false, 1, 0);
    private static final int[] RGBABits8 = new int[]{8, 8, 8, 8};
    private static final ComponentColorModel colorModelRGBA8 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBABits8, true, false, 3, 0);
    private static final int[] RGBBits16 = new int[]{16, 16, 16};
    private static final ComponentColorModel colorModelRGB16 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits16, false, false, 1, 1);
    private static final int[] RGBABits16 = new int[]{16, 16, 16, 16};
    private static final ComponentColorModel colorModelRGBA16 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBABits16, true, false, 3, 1);
    private static final int[] RGBBits32 = new int[]{32, 32, 32};
    private static final ComponentColorModel colorModelRGB32 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits32, false, false, 1, 3);
    private static final int[] RGBABits32 = new int[]{32, 32, 32, 32};
    private static final ComponentColorModel colorModelRGBA32 = new ComponentColorModel(ColorSpace.getInstance(1000), RGBABits32, true, false, 3, 3);

    protected ImageCodec() {
    }

    public static ImageCodec getCodec(String string) {
        return (ImageCodec)codecs.get(string.toLowerCase());
    }

    public static Enumeration getCodecs() {
        return codecs.elements();
    }

    public static String[] getDecoderNames(SeekableStream seekableStream) {
        if (!seekableStream.canSeekBackwards() && !seekableStream.markSupported()) {
            throw new IllegalArgumentException(JaiI18N.getString("ImageCodec2"));
        }
        Enumeration enumeration = codecs.elements();
        Vector<String> vector = new Vector<String>();
        Object var3_3 = null;
        while (enumeration.hasMoreElements()) {
            ImageCodec imageCodec = (ImageCodec)enumeration.nextElement();
            int n = imageCodec.getNumHeaderBytes();
            if (n == 0 && !seekableStream.canSeekBackwards()) continue;
            try {
                if (n > 0) {
                    seekableStream.mark(n);
                    byte[] byArray = new byte[n];
                    seekableStream.readFully(byArray);
                    seekableStream.reset();
                    if (!imageCodec.isFormatRecognized(byArray)) continue;
                    vector.add(imageCodec.getFormatName());
                    continue;
                }
                long l = seekableStream.getFilePointer();
                seekableStream.seek(0L);
                if (imageCodec.isFormatRecognized(seekableStream)) {
                    vector.add(imageCodec.getFormatName());
                }
                seekableStream.seek(l);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return ImageCodec.vectorToStrings(vector);
    }

    public static String[] getEncoderNames(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        Enumeration enumeration = codecs.elements();
        Vector<String> vector = new Vector<String>();
        Object var4_4 = null;
        while (enumeration.hasMoreElements()) {
            ImageCodec imageCodec = (ImageCodec)enumeration.nextElement();
            if (!imageCodec.canEncodeImage(renderedImage, imageEncodeParam)) continue;
            vector.add(imageCodec.getFormatName());
        }
        return ImageCodec.vectorToStrings(vector);
    }

    public static void registerCodec(ImageCodec imageCodec) {
        codecs.put(imageCodec.getFormatName().toLowerCase(), imageCodec);
    }

    public static void unregisterCodec(String string) {
        codecs.remove(string.toLowerCase());
    }

    public static ImageEncoder createImageEncoder(String string, OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        ImageCodec imageCodec = ImageCodec.getCodec(string);
        if (imageCodec == null) {
            return null;
        }
        return imageCodec.createImageEncoder(outputStream, imageEncodeParam);
    }

    public static ImageDecoder createImageDecoder(String string, InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        ImageCodec imageCodec = ImageCodec.getCodec(string);
        if (imageCodec == null) {
            return null;
        }
        return imageCodec.createImageDecoder(inputStream, imageDecodeParam);
    }

    public static ImageDecoder createImageDecoder(String string, File file, ImageDecodeParam imageDecodeParam) throws IOException {
        ImageCodec imageCodec = ImageCodec.getCodec(string);
        if (imageCodec == null) {
            return null;
        }
        return imageCodec.createImageDecoder(file, imageDecodeParam);
    }

    public static ImageDecoder createImageDecoder(String string, SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        ImageCodec imageCodec = ImageCodec.getCodec(string);
        if (imageCodec == null) {
            return null;
        }
        return imageCodec.createImageDecoder(seekableStream, imageDecodeParam);
    }

    public static ColorModel createGrayIndexColorModel(SampleModel sampleModel, boolean bl) {
        byte[] byArray;
        int n;
        block7: {
            block6: {
                if (sampleModel.getNumBands() != 1) {
                    throw new IllegalArgumentException();
                }
                n = sampleModel.getSampleSize(0);
                byArray = null;
                if (n >= 8) break block6;
                byArray = grayIndexCmaps[n];
                if (bl) break block7;
                int n2 = byArray.length;
                byte[] byArray2 = new byte[n2];
                for (int i = 0; i < n2; ++i) {
                    byArray2[i] = byArray[n2 - i - 1];
                }
                byArray = byArray2;
                break block7;
            }
            byArray = new byte[256];
            if (bl) {
                for (int i = 0; i < 256; ++i) {
                    byArray[i] = (byte)i;
                }
            } else {
                for (int i = 0; i < 256; ++i) {
                    byArray[i] = (byte)(255 - i);
                }
            }
        }
        return new IndexColorModel(n, byArray.length, byArray, byArray, byArray);
    }

    public static ColorModel createComponentColorModel(SampleModel sampleModel) {
        int n = sampleModel.getDataType();
        int n2 = sampleModel.getNumBands();
        ComponentColorModel componentColorModel = null;
        if (n == 0) {
            switch (n2) {
                case 1: {
                    componentColorModel = colorModelGray8;
                    break;
                }
                case 2: {
                    componentColorModel = colorModelGrayAlpha8;
                    break;
                }
                case 3: {
                    componentColorModel = colorModelRGB8;
                    break;
                }
                case 4: {
                    componentColorModel = colorModelRGBA8;
                }
            }
        } else if (n == 1) {
            switch (n2) {
                case 1: {
                    componentColorModel = colorModelGray16;
                    break;
                }
                case 2: {
                    componentColorModel = colorModelGrayAlpha16;
                    break;
                }
                case 3: {
                    componentColorModel = colorModelRGB16;
                    break;
                }
                case 4: {
                    componentColorModel = colorModelRGBA16;
                }
            }
        } else if (n == 3) {
            switch (n2) {
                case 1: {
                    componentColorModel = colorModelGray32;
                    break;
                }
                case 2: {
                    componentColorModel = colorModelGrayAlpha32;
                    break;
                }
                case 3: {
                    componentColorModel = colorModelRGB32;
                    break;
                }
                case 4: {
                    componentColorModel = colorModelRGBA32;
                }
            }
        } else if (n == 4 && n2 >= 1 && n2 <= 4) {
            ColorSpace colorSpace = n2 <= 2 ? ColorSpace.getInstance(1003) : ColorSpace.getInstance(1000);
            boolean bl = n2 % 2 == 0;
            componentColorModel = new FloatDoubleColorModel(colorSpace, bl, false, bl ? 3 : 1, 4);
        }
        return componentColorModel;
    }

    private static String[] vectorToStrings(Vector vector) {
        int n = vector.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public abstract String getFormatName();

    public int getNumHeaderBytes() {
        return 0;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        throw new RuntimeException(JaiI18N.getString("ImageCodec0"));
    }

    public boolean isFormatRecognized(SeekableStream seekableStream) throws IOException {
        throw new RuntimeException(JaiI18N.getString("ImageCodec1"));
    }

    public abstract boolean canEncodeImage(RenderedImage var1, ImageEncodeParam var2);

    protected abstract Class getEncodeParamClass();

    protected abstract Class getDecodeParamClass();

    protected abstract ImageEncoder createImageEncoder(OutputStream var1, ImageEncodeParam var2);

    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        SeekableStream seekableStream = SeekableStream.wrapInputStream(inputStream, true);
        return this.createImageDecoder(seekableStream, imageDecodeParam);
    }

    protected ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) throws IOException {
        return this.createImageDecoder(new FileSeekableStream(file), imageDecodeParam);
    }

    protected abstract ImageDecoder createImageDecoder(SeekableStream var1, ImageDecodeParam var2);

    static {
        ImageCodec.registerCodec(new BMPCodec());
        ImageCodec.registerCodec(new GIFCodec());
        ImageCodec.registerCodec(new FPXCodec());
        ImageCodec.registerCodec(new JPEGCodec());
        ImageCodec.registerCodec(new PNGCodec());
        ImageCodec.registerCodec(new PNMCodec());
        ImageCodec.registerCodec(new TIFFCodec());
    }
}

