/*
 * Decompiled with CFR 0.152.
 */
package non_com.media.jai.codec;

import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import non_com.media.jai.codec.BMPEncodeParam;
import non_com.media.jai.codec.BMPImageDecoder;
import non_com.media.jai.codec.BMPImageEncoder;
import non_com.media.jai.codec.ImageCodec;
import non_com.media.jai.codec.ImageDecodeParam;
import non_com.media.jai.codec.ImageDecoder;
import non_com.media.jai.codec.ImageEncodeParam;
import non_com.media.jai.codec.ImageEncoder;
import non_com.media.jai.codec.SeekableStream;

public final class BMPCodec
extends ImageCodec {
    static /* synthetic */ Class class$non_com$media$jai$codec$BMPEncodeParam;
    static /* synthetic */ Class class$java$lang$Object;

    public String getFormatName() {
        return "bmp";
    }

    public Class getEncodeParamClass() {
        return class$non_com$media$jai$codec$BMPEncodeParam == null ? (class$non_com$media$jai$codec$BMPEncodeParam = BMPCodec.class$("non_com.media.jai.codec.BMPEncodeParam")) : class$non_com$media$jai$codec$BMPEncodeParam;
    }

    public Class getDecodeParamClass() {
        return class$java$lang$Object == null ? (class$java$lang$Object = BMPCodec.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public int getNumHeaderBytes() {
        return 2;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == 66 && byArray[1] == 77;
    }

    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n = sampleModel.getTransferType();
        if (n == 1 || n == 2 || n == 3 || n == 4 || n == 5) {
            return false;
        }
        if (imageEncodeParam != null) {
            if (!(imageEncodeParam instanceof BMPEncodeParam)) {
                return false;
            }
            BMPEncodeParam bMPEncodeParam = (BMPEncodeParam)imageEncodeParam;
            int n2 = bMPEncodeParam.getVersion();
            if (n2 == 0 || n2 == 2) {
                return false;
            }
        }
        return true;
    }

    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        BMPEncodeParam bMPEncodeParam = null;
        if (imageEncodeParam != null) {
            bMPEncodeParam = (BMPEncodeParam)imageEncodeParam;
        }
        return new BMPImageEncoder(outputStream, bMPEncodeParam);
    }

    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        return new BMPImageDecoder(inputStream, null);
    }

    protected ImageDecoder createImageDecoder(File file, ImageDecodeParam imageDecodeParam) throws IOException {
        return new BMPImageDecoder(new FileInputStream(file), null);
    }

    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new BMPImageDecoder((InputStream)seekableStream, null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

