/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import java.io.File;
import java.util.ArrayList;
import net.sf.ij.jaiio.ImageFileChooser;
import net.sf.ij.jaiio.JAIFileChooserFactory;
import net.sf.ij.jaiio.JAIReader;

public class ImageIOOpenPlugin
implements PlugIn {
    private static final String TITLE = "Image IO Open";
    public static final String ARG_SIMPLE = "simple";
    public static final String ARG_IMAGE_PREVIEW = "preview";
    private static ImageFileChooser jaiChooser;
    private int[] pageIndex;
    private File[] files;
    private boolean combineIntoStack = true;

    private void open(File[] files, int[] pageIndex) {
        ArrayList<ImagePlus> imageList = null;
        if (this.combineIntoStack) {
            imageList = new ArrayList<ImagePlus>();
        }
        for (int i = 0; i < files.length; ++i) {
            IJ.showStatus((String)("Opening: " + files[i].getName()));
            try {
                ImagePlus[] images = JAIReader.read(files[i], pageIndex);
                if (images == null) continue;
                for (int j = 0; j < images.length; ++j) {
                    if (imageList != null) {
                        imageList.add(images[j]);
                        continue;
                    }
                    images[j].show();
                }
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                String msg = "Error opening file: " + files[i].getName() + ".\n\n";
                msg = msg + (ex.getMessage() == null ? ex.toString() : ex.getMessage());
                IJ.showMessage((String)TITLE, (String)msg);
            }
        }
        if (imageList != null) {
            ImagePlus stackImage = ImageIOOpenPlugin.combineImages(imageList);
            if (stackImage != null) {
                imageList = null;
                stackImage.show();
            } else {
                IJ.showMessage((String)TITLE, (String)"Unable to combine images into a stack.\nLoading each separately.");
                for (int i = 0; i < imageList.size(); ++i) {
                    ((ImagePlus)imageList.get(i)).show();
                }
            }
        }
    }

    private static ImagePlus combineImages(ArrayList imageList) {
        if (imageList == null || imageList.size() < 1) {
            return null;
        }
        if (imageList.size() == 1) {
            return (ImagePlus)imageList.get(0);
        }
        ImagePlus firstImage = (ImagePlus)imageList.get(0);
        if (firstImage.getStackSize() != 1) {
            return null;
        }
        int fileType = firstImage.getFileInfo().fileType;
        int w = firstImage.getWidth();
        int h = firstImage.getHeight();
        ImageStack stack = firstImage.getStack();
        for (int i = 1; i < imageList.size(); ++i) {
            ImagePlus im = (ImagePlus)imageList.get(i);
            if (im.getStackSize() != 1) {
                return null;
            }
            if (fileType != im.getFileInfo().fileType || w != im.getWidth() || h != im.getHeight()) {
                return null;
            }
            stack.addSlice(im.getTitle(), im.getProcessor().getPixels());
        }
        firstImage.setStack(firstImage.getTitle(), stack);
        return firstImage;
    }

    public void run(String arg) {
        IJ.showStatus((String)"Starting \"Image IO Open\" plugin...");
        String type = arg == null ? ARG_SIMPLE : arg.trim().toLowerCase();
        this.files = null;
        this.pageIndex = null;
        if (type.equals(ARG_IMAGE_PREVIEW)) {
            this.selectFilesWithImagePreview();
        } else {
            this.selectFiles();
        }
        if (this.files == null) {
            return;
        }
        if (this.files.length > 1) {
            this.combineIntoStack = IJ.showMessageWithCancel((String)TITLE, (String)("" + this.files.length + " files selected.\n" + "Should the images be combined into a stack?"));
        }
        if (this.files != null) {
            IJ.showStatus((String)"Opening seleced image file...");
            this.open(this.files, this.pageIndex);
        }
        IJ.showStatus((String)"");
    }

    private void selectFilesWithImagePreview() {
        if (jaiChooser == null) {
            jaiChooser = JAIFileChooserFactory.createJAIOpenChooser();
            String dirName = OpenDialog.getDefaultDirectory();
            File dirFile = new File(dirName);
            jaiChooser.setCurrentDirectory(dirFile);
            jaiChooser.setMultiSelectionEnabled(true);
        }
        if (jaiChooser.showOpenDialog(null) == 0) {
            this.files = jaiChooser.getSelectedFiles();
            this.pageIndex = jaiChooser.getPageIndex();
        } else {
            this.files = null;
            this.pageIndex = null;
        }
    }

    private void selectFiles() {
        this.pageIndex = null;
        OpenDialog openDialog = new OpenDialog(TITLE, null);
        if (openDialog.getFileName() == null) {
            this.files = null;
            return;
        }
        if (this.files == null || this.files.length != 1) {
            this.files = new File[1];
        }
        this.files[0] = new File(openDialog.getDirectory(), openDialog.getFileName());
    }
}

