/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ij.jaiio;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import net.sf.ij.jaiio.JAIFileFilter;
import non_com.media.jai.codec.ImageCodec;
import non_com.media.jai.codec.ImageEncoder;

public class SaveImageFileChooser
extends JFileChooser
implements PropertyChangeListener {
    private String selectedFileDirectory = null;
    private String selectedFileRootName = null;

    public SaveImageFileChooser(File currentDirectory) {
        super(currentDirectory);
        this.addPropertyChangeListener(this);
        this.setMultiSelectionEnabled(false);
        this.setDialogType(1);
        this.setAcceptAllFileFilterUsed(false);
        Enumeration codecs = ImageCodec.getCodecs();
        TreeSet<String> codecSet = new TreeSet<String>();
        while (codecs.hasMoreElements()) {
            ImageCodec thisCodec = (ImageCodec)codecs.nextElement();
            String formatName = thisCodec.getFormatName();
            try {
                ImageEncoder imageEncoder = ImageCodec.createImageEncoder(formatName, null, null);
                if (imageEncoder == null) continue;
                codecSet.add(formatName);
            }
            catch (Throwable t) {}
        }
        JAIFileFilter defaultFilter = null;
        Iterator i = codecSet.iterator();
        while (i.hasNext()) {
            try {
                String cadecName = (String)i.next();
                JAIFileFilter jaiFileFilter = new JAIFileFilter(cadecName);
                this.addChoosableFileFilter(jaiFileFilter);
                if (cadecName.toUpperCase().indexOf("TIFF") <= -1) continue;
                defaultFilter = jaiFileFilter;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (defaultFilter != null) {
            this.setFileFilter(defaultFilter);
        }
        this.validate();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (evt.getPropertyName().equals("fileFilterChanged")) {
            FileFilter fileFilter = this.getFileFilter();
            if (fileFilter instanceof JAIFileFilter) {
                JAIFileFilter jaiFileFilter = (JAIFileFilter)fileFilter;
                if (this.selectedFileDirectory != null) {
                    String fileName = this.selectedFileDirectory + File.separator + this.selectedFileRootName + "." + jaiFileFilter.getCodecName().toLowerCase();
                    final File selectedFile = new File(fileName);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SaveImageFileChooser.this.setSelectedFile(selectedFile);
                        }
                    });
                }
            }
        } else if (evt.getPropertyName().equals("SelectedFileChangedProperty")) {
            File selectedFile = this.getSelectedFile();
            if (selectedFile == null) {
                if (this.selectedFileDirectory != null) {
                    FileFilter fileFilter = this.getFileFilter();
                    JAIFileFilter jaiFileFilter = (JAIFileFilter)fileFilter;
                    String name = this.selectedFileDirectory + File.separator + this.selectedFileRootName + "." + jaiFileFilter.getCodecName().toLowerCase();
                    final File recoveredSelectedFile = new File(name);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            SaveImageFileChooser.this.setSelectedFile(recoveredSelectedFile);
                        }
                    });
                }
            } else {
                File parentFile = selectedFile.getParentFile();
                this.selectedFileDirectory = this.getCurrentDirectory().getAbsolutePath();
                String name = selectedFile.getName();
                int lastDot = name.lastIndexOf(".");
                if (lastDot > -1) {
                    this.selectedFileRootName = name.substring(0, lastDot);
                }
            }
        } else if (evt.getPropertyName().equals("directoryChanged")) {
            File newValue = (File)evt.getNewValue();
            if (newValue != null) {
                this.selectedFileDirectory = newValue.getAbsolutePath();
            }
            if (this.selectedFileDirectory != null) {
                FileFilter fileFilter = this.getFileFilter();
                JAIFileFilter jaiFileFilter = (JAIFileFilter)fileFilter;
                String fileName = this.selectedFileDirectory + File.separator + this.selectedFileRootName + "." + jaiFileFilter.getCodecName().toLowerCase();
                final File selectedFile = new File(fileName);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SaveImageFileChooser.this.setSelectedFile(selectedFile);
                    }
                });
            }
        }
    }
}

