/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ij.jaiio;

import ij.ImagePlus;
import ij.measure.Calibration;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import net.sf.ij.jaiio.BufferedImageCreator;
import net.sf.ij.jaiio.DescriptionStringCoder;
import non_com.media.jai.codec.ImageCodec;
import non_com.media.jai.codec.ImageEncodeParam;
import non_com.media.jai.codec.ImageEncoder;
import non_com.media.jai.codec.TIFFEncodeParam;
import non_com.media.jai.codec.TIFFField;
import non_com.media.jai.codec.TIFFImageEncoder;

public class JAIWriter {
    private static final double TIFF_RATIONAL_SCALE = 1000000.0;
    private static final String TIFF_FORMAT_NAME = "tiff";
    private static final String DEFAULT_FORMAT_NAME = "tiff";
    private String formatName = "tiff";
    private ImageEncodeParam encodeParam;

    public static String[] getFormatNames() {
        Enumeration codecs = ImageCodec.getCodecs();
        ArrayList<String> l = new ArrayList<String>();
        while (codecs.hasMoreElements()) {
            ImageCodec imageCodec = (ImageCodec)codecs.nextElement();
            l.add(imageCodec.getFormatName());
        }
        return l.toArray(new String[l.size()]);
    }

    private static long[][] toRational(double x) {
        long[][] r = new long[][]{{(long)(1000000.0 * x), 1000000L}};
        return r;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    public String getFormatName() {
        return this.formatName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String fileName, ImagePlus im) throws FileNotFoundException, IOException, IllegalArgumentException {
        boolean successfulWrite = false;
        File imageFile = new File(fileName);
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(imageFile));
        try {
            ImageEncoder imageEncoder = ImageCodec.createImageEncoder(this.formatName, outputStream, null);
            if (imageEncoder instanceof TIFFImageEncoder) {
                TIFFEncodeParam param = (TIFFEncodeParam)(this.encodeParam instanceof TIFFEncodeParam ? this.encodeParam : null);
                if (param == null) {
                    param = new TIFFEncodeParam();
                }
                BufferedImage bi = BufferedImageCreator.create(im, 0);
                ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
                for (int i = 1; i < im.getStackSize(); ++i) {
                    list.add(BufferedImageCreator.create(im, i));
                }
                if (list.size() > 0) {
                    param.setExtraImages(list.iterator());
                }
                ArrayList<TIFFField> extraTags = new ArrayList<TIFFField>();
                String[] desciption = new String[]{DescriptionStringCoder.encode(im)};
                extraTags.add(new TIFFField(270, 2, 1, desciption));
                Calibration calib = im.getCalibration();
                if (calib != null) {
                    if (calib.pixelWidth != 0.0) {
                        extraTags.add(new TIFFField(282, 5, 1, JAIWriter.toRational(1.0 / calib.pixelWidth)));
                    }
                    if (calib.pixelHeight != 0.0) {
                        extraTags.add(new TIFFField(283, 5, 1, JAIWriter.toRational(1.0 / calib.pixelHeight)));
                    }
                    String unitName = calib.getUnit();
                    int unitCode = 0;
                    if (unitName == null || unitName.trim().length() == 0) {
                        unitCode = 1;
                    } else if (unitName.compareToIgnoreCase("inch") == 0) {
                        unitCode = 2;
                    } else if (unitName.compareToIgnoreCase("cm") == 0) {
                        unitCode = 3;
                    }
                    if (unitCode > 0) {
                        int[] unit = new int[]{unitCode};
                        extraTags.add(new TIFFField(296, 3, 1, JAIWriter.intsToChars(unit)));
                    }
                }
                param.setExtraFields(extraTags.toArray(new TIFFField[extraTags.size()]));
                imageEncoder.setParam(param);
                imageEncoder.encode(bi);
            } else {
                if (im.getStackSize() > 1) {
                    throw new IllegalArgumentException(this.formatName.toUpperCase() + " format does not support multi-image files. " + "Image was not saved.");
                }
                BufferedImage bi = BufferedImageCreator.create(im, 0);
                imageEncoder.encode(bi);
            }
            successfulWrite = true;
        }
        finally {
            outputStream.close();
            if (!successfulWrite) {
                imageFile.delete();
            }
        }
    }

    private static final char[] intsToChars(int[] intArray) {
        int arrayLength = intArray.length;
        char[] charArray = new char[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            charArray[i] = (char)(intArray[i] & 0xFFFF);
        }
        return charArray;
    }

    public void setImageEncodeParam(ImageEncodeParam encodeParam) {
        this.encodeParam = encodeParam;
    }
}

