/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ij.jaiio;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.Opener;
import ij.measure.Calibration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.sf.ij.jaiio.DescriptionStringCoder;
import net.sf.ij.jaiio.ImagePlusCreator;
import net.sf.ij.jaiio.UnsupportedImageFileFormatException;
import net.sf.ij.jaiio.UnsupportedImageModelException;
import non_com.media.jai.FloatDoubleColorModel;
import non_com.media.jai.codec.FileSeekableStream;
import non_com.media.jai.codec.ImageCodec;
import non_com.media.jai.codec.ImageDecoder;
import non_com.media.jai.codec.TIFFDirectory;
import non_com.media.jai.codec.TIFFField;
import non_com.media.jai.codec.TIFFImage;

public class JAIReader {
    private ImageDecoder decoder = null;
    private String decoderName = null;
    private File file = null;

    private JAIReader() {
    }

    public static ImageInfo readFirstImageAndInfo(File file) throws UnsupportedImageFileFormatException, UnsupportedImageModelException, IOException {
        FileSeekableStream fss = new FileSeekableStream(file);
        String[] decoders = ImageCodec.getDecoderNames(fss);
        if (decoders == null || decoders.length == 0) {
            throw new UnsupportedImageFileFormatException("Unsupported file format. Cannot find decoder capable of reading: " + file.getName());
        }
        ImageDecoder decoder = ImageCodec.createImageDecoder(decoders[0], fss, null);
        RenderedImage renderedImage = decoder.decodeAsRenderedImage();
        ImageInfo imageInfo = new ImageInfo();
        imageInfo.numberOfPages = decoder.getNumPages();
        imageInfo.codecName = decoders[0];
        if (renderedImage instanceof Image) {
            imageInfo.previewImage = (Image)((Object)renderedImage);
        } else {
            ColorModel cm = renderedImage.getColorModel();
            if (cm == null || cm instanceof FloatDoubleColorModel) {
                WritableRaster writableRaster = ImagePlusCreator.forceTileUpdate(renderedImage);
                ImagePlus imagePlus = ImagePlusCreator.create(writableRaster, null);
                imageInfo.previewImage = imagePlus.getImage();
            } else {
                Raster raster = renderedImage.getData();
                WritableRaster writableRaster = raster instanceof WritableRaster ? (WritableRaster)raster : raster.createCompatibleWritableRaster();
                imageInfo.previewImage = new BufferedImage(cm, writableRaster, false, null);
            }
        }
        return imageInfo;
    }

    public static ImagePlus[] read(File file) throws Exception {
        return JAIReader.read(file, null);
    }

    public static ImagePlus[] read(File file, int[] pageIndex) throws Exception {
        JAIReader reader = new JAIReader();
        reader.open(file);
        int nbPages = reader.getNumPages();
        if (nbPages < 1) {
            throw new Exception("Image decoding problem. Image file has less then 1 page. Nothing to decode.");
        }
        if (pageIndex == null) {
            pageIndex = new int[nbPages];
            for (int i = 0; i < nbPages; ++i) {
                pageIndex[i] = i;
            }
        }
        IJ.showProgress((double)0.0);
        ArrayList<ImagePlus> imageList = new ArrayList<ImagePlus>();
        for (int i = 0; i < pageIndex.length; ++i) {
            if (pageIndex[i] != 0) {
                IJ.showStatus((String)("Reading page " + pageIndex[i]));
            }
            imageList.add(reader.read(pageIndex[i]));
            IJ.showProgress((double)((double)(i + 1) / (double)pageIndex.length));
        }
        IJ.showProgress((double)1.0);
        reader.close();
        reader = null;
        ImagePlus[] images = imageList.toArray(new ImagePlus[imageList.size()]);
        if (nbPages == 1) {
            images[0].setTitle(file.getName());
        } else {
            ImagePlus im = JAIReader.combineImages(images);
            if (im != null) {
                im.setTitle(file.getName());
                images = new ImagePlus[]{im};
            }
        }
        return images;
    }

    private static ImagePlus combineImages(ImagePlus[] images) {
        if (images == null || images.length <= 1) {
            return null;
        }
        if (images[0].getStackSize() != 1) {
            return null;
        }
        int fileType = images[0].getFileInfo().fileType;
        int w = images[0].getWidth();
        int h = images[0].getHeight();
        ImageStack stack = images[0].getStack();
        for (int i = 1; i < images.length; ++i) {
            ImagePlus im = images[i];
            if (im.getStackSize() != 1) {
                return null;
            }
            if (fileType != im.getFileInfo().fileType || w != im.getWidth() || h != im.getHeight()) {
                return null;
            }
            stack.addSlice(null, im.getProcessor().getPixels());
        }
        images[0].setStack(images[0].getTitle(), stack);
        return images[0];
    }

    private int getNumPages() throws IOException {
        return this.decoder.getNumPages();
    }

    private void open(File file) throws Exception {
        this.file = file;
        FileSeekableStream fss = new FileSeekableStream(file);
        String[] decoders = ImageCodec.getDecoderNames(fss);
        if (decoders == null || decoders.length == 0) {
            throw new Exception("Unsupported file format. Cannot find decoder capable of reading: " + file.getName());
        }
        this.decoderName = decoders[0];
        this.decoder = ImageCodec.createImageDecoder(this.decoderName, fss, null);
    }

    private ImagePlus read(int pageNb) throws Exception {
        ImagePlus im;
        block22: {
            RenderedImage ri = null;
            try {
                ri = this.decoder.decodeAsRenderedImage(pageNb);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                String msg = ex.getMessage();
                if (msg == null || msg.trim().length() < 1) {
                    msg = "Error decoding rendered image.";
                }
                throw new Exception(msg);
            }
            WritableRaster wr = ImagePlusCreator.forceTileUpdate(ri);
            if (this.decoderName.equalsIgnoreCase("GIF") || this.decoderName.equalsIgnoreCase("JPEG")) {
                BufferedImage bi = new BufferedImage(ri.getColorModel(), wr, false, null);
                im = new ImagePlus(this.file.getName(), (Image)bi);
                if (im.getType() == 4) {
                    Opener.convertGrayJpegTo8Bits((ImagePlus)im);
                }
            } else {
                im = ImagePlusCreator.create(wr, ri.getColorModel());
                im.setTitle(this.file.getName() + " [" + (pageNb + 1) + "/" + this.getNumPages() + "]");
                if (im.getType() == 4) {
                    Opener.convertGrayJpegTo8Bits((ImagePlus)im);
                }
                if (ri instanceof TIFFImage) {
                    TIFFImage ti = (TIFFImage)ri;
                    try {
                        TIFFField resolutionUnitField;
                        double yRes;
                        TIFFField yResField;
                        double xRes;
                        TIFFField xResField;
                        Calibration c;
                        Object o = ti.getProperty("tiff_directory");
                        if (!(o instanceof TIFFDirectory)) break block22;
                        TIFFDirectory dir = (TIFFDirectory)o;
                        TIFFField descriptionField = dir.getField(270);
                        if (descriptionField != null) {
                            try {
                                DescriptionStringCoder.decode(descriptionField.getAsString(0), im);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                        if ((c = im.getCalibration()) == null) {
                            c = new Calibration(im);
                        }
                        if ((xResField = dir.getField(282)) != null && (xRes = xResField.getAsDouble(0)) != 0.0) {
                            c.pixelWidth = 1.0 / xRes;
                        }
                        if ((yResField = dir.getField(283)) != null && (yRes = yResField.getAsDouble(0)) != 0.0) {
                            c.pixelHeight = 1.0 / yRes;
                        }
                        if ((resolutionUnitField = dir.getField(296)) != null) {
                            int resolutionUnit = resolutionUnitField.getAsInt(0);
                            if (resolutionUnit == 1 && c.getUnit() == null) {
                                c.setUnit(" ");
                            } else if (resolutionUnit == 2) {
                                c.setUnit("inch");
                            } else if (resolutionUnit == 3) {
                                c.setUnit("cm");
                            }
                        }
                        im.setCalibration(c);
                    }
                    catch (NegativeArraySizeException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        return im;
    }

    private void close() {
        this.decoder = null;
        this.decoderName = null;
        this.file = null;
    }

    public static class ImageInfo {
        public Image previewImage;
        public int numberOfPages;
        public String codecName;
    }
}

