/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ij.jaiio;

import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.ij.jaiio.ImagePageSelectionDialog;
import net.sf.ij.jaiio.JAIReader;
import net.sf.ij.jaiio.UnsupportedImageFileFormatException;
import net.sf.ij.jaiio.UnsupportedImageModelException;

public class JAIFilePreviewer
extends JPanel
implements PropertyChangeListener {
    static final String FILE_SIZE_PREFIX = "";
    static final long SIZE_KB = 1024L;
    static final long SIZE_MB = 0x100000L;
    static final long SIZE_GB = 0x40000000L;
    protected File file;
    protected int iconSizeX = 150;
    protected int iconSizeY = 100;
    private JAIReader.ImageInfo imageInfo = null;
    private int[] pageIndex = null;
    private ImagePageSelectionDialog imagePageSelectionDialog = new ImagePageSelectionDialog();
    private JFileChooser parentChooser;
    private JPanel infoPanel = new JPanel();
    private JLabel fileSizeLabel = new JLabel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JLabel ImageIconLabel = new JLabel();
    private JButton selectPagesButton = new JButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();

    public JAIFilePreviewer() {
        try {
            this.jbInit();
            ImagePlus imp = new ImagePlus(FILE_SIZE_PREFIX, (ImageProcessor)new ByteProcessor(this.iconSizeX, this.iconSizeY));
            ImageIcon imageIcon = new ImageIcon(imp.getImage());
            this.ImageIconLabel.setIcon(imageIcon);
            this.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JAIFilePreviewer(JFileChooser fc) {
        this.parentChooser = fc;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        fc.addPropertyChangeListener(this);
    }

    public int[] getPageIndex() {
        int[] r;
        if (this.pageIndex != null) {
            r = new int[this.pageIndex.length];
            System.arraycopy(this.pageIndex, 0, r, 0, this.pageIndex.length);
        } else {
            r = null;
        }
        return r;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if ("SelectedFileChangedProperty".equals(prop)) {
            this.file = (File)e.getNewValue();
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    void selectPagesButton_actionPerformed(ActionEvent e) {
        if (this.imageInfo == null) {
            return;
        }
        if (this.parentChooser.getSelectedFiles() != null && this.parentChooser.getSelectedFiles().length > 1) {
            this.selectPagesButton.setEnabled(false);
            JOptionPane.showMessageDialog(this, "Cannot select pages when multiple files are selected.", "Select pages...", 2);
            return;
        }
        this.imagePageSelectionDialog.setNumPages(this.imageInfo.numberOfPages);
        this.imagePageSelectionDialog.setVisible(true);
        this.pageIndex = this.imagePageSelectionDialog.getPageIndex();
    }

    private String getFileSizeString(long fileSize) {
        String fileSizeString = fileSize < 1024L ? FILE_SIZE_PREFIX + fileSize : (fileSize < 0x100000L ? FILE_SIZE_PREFIX + (int)((double)fileSize / 1024.0 + 0.5) + "KB" : (fileSize < 0x40000000L ? FILE_SIZE_PREFIX + (int)((double)fileSize / 1048576.0 + 0.5) + "MB" : FILE_SIZE_PREFIX + (int)((double)fileSize / 1.073741824E9 + 0.5) + "GB"));
        return fileSizeString;
    }

    private JAIReader.ImageInfo loadImage() {
        this.pageIndex = null;
        if (this.file == null || this.file.isDirectory()) {
            this.fileSizeLabel.setText(" ");
            this.selectPagesButton.setEnabled(false);
            return null;
        }
        try {
            this.imageInfo = JAIReader.readFirstImageAndInfo(this.file);
        }
        catch (UnsupportedImageModelException e) {
            this.ImageIconLabel.setIcon(null);
            this.fileSizeLabel.setText("Unsupported image model");
            return null;
        }
        catch (UnsupportedImageFileFormatException e) {
            this.ImageIconLabel.setIcon(null);
            this.fileSizeLabel.setText("Unsupported file format");
            return null;
        }
        catch (IOException e) {
            this.ImageIconLabel.setIcon(null);
            this.fileSizeLabel.setText("I/O Error");
            return null;
        }
        catch (RuntimeException e) {
            this.ImageIconLabel.setIcon(null);
            this.fileSizeLabel.setText("Error decoding image");
            return null;
        }
        Image image = this.imageInfo.previewImage;
        StringBuffer label = new StringBuffer(this.getFileSizeString(this.file.length()));
        if (image != null) {
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            if (w > 0 && h > 0) {
                label.append("  [" + w + "x" + h);
                if (this.imageInfo.numberOfPages > 1) {
                    label.append("x" + this.imageInfo.numberOfPages + "]");
                    File[] selectedFiles = this.parentChooser.getSelectedFiles();
                    File selectedFile = this.parentChooser.getSelectedFile();
                    if (selectedFiles != null && selectedFiles.length == 1 || (selectedFiles == null || selectedFiles.length == 0) && selectedFile != null) {
                        this.selectPagesButton.setEnabled(true);
                    } else {
                        this.selectPagesButton.setEnabled(false);
                    }
                } else {
                    label.append("]");
                    this.selectPagesButton.setEnabled(false);
                }
            }
            int xSizeBuffered = image.getWidth(null);
            int ySizeBuffered = image.getHeight(null);
            if (xSizeBuffered > this.iconSizeX || ySizeBuffered > this.iconSizeY) {
                double scaleX = (double)this.iconSizeX / (double)xSizeBuffered;
                double scaleY = (double)this.iconSizeY / (double)ySizeBuffered;
                Object scaledImage = null;
                image = scaleX < scaleY ? image.getScaledInstance(this.iconSizeX, -1, 1) : image.getScaledInstance(-1, this.iconSizeY, 1);
            }
            ImageIcon imageIcon = new ImageIcon(image);
            this.ImageIconLabel.setIcon(imageIcon);
        } else {
            this.ImageIconLabel.setIcon(null);
        }
        this.fileSizeLabel.setText(label.toString());
        return this.imageInfo;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.fileSizeLabel.setHorizontalAlignment(0);
        this.fileSizeLabel.setHorizontalTextPosition(0);
        this.fileSizeLabel.setText(" ");
        this.infoPanel.setLayout(this.borderLayout1);
        this.ImageIconLabel.setMaximumSize(new Dimension(this.iconSizeX, this.iconSizeY));
        this.ImageIconLabel.setMinimumSize(new Dimension(this.iconSizeX, this.iconSizeY));
        this.ImageIconLabel.setPreferredSize(new Dimension(this.iconSizeX, this.iconSizeY));
        this.ImageIconLabel.setHorizontalAlignment(0);
        this.selectPagesButton.setEnabled(false);
        this.selectPagesButton.setText("Select pages...");
        this.selectPagesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JAIFilePreviewer.this.selectPagesButton_actionPerformed(e);
            }
        });
        this.add((Component)this.infoPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.infoPanel.add((Component)this.fileSizeLabel, "Center");
        this.add((Component)this.ImageIconLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.selectPagesButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 15, 0, new Insets(0, 0, 0, 0), 0, 0));
    }
}

