/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ij.jaiio;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.filechooser.FileFilter;
import non_com.media.jai.codec.ImageCodec;

public class JAIFileFilter
extends FileFilter {
    public static final int MIN_IMAGE_FILE_SIZE = 8;
    private String codecName = null;
    private String decription = "All Supported Images";
    private ImageCodec[] activeCodecs = null;
    private int maxHeaderSize = 0;
    private byte[] headerBytes = null;

    public JAIFileFilter() {
        this.setupFilter(null);
    }

    public JAIFileFilter(String codecName) {
        this.setupFilter(codecName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readHeaderSample(File file, byte[] headerBytes) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            int bytesRead = fis.read(headerBytes);
            if (bytesRead < headerBytes.length) {
                throw new EOFException("File to short to read header.");
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public String getDescription() {
        return this.decription;
    }

    public String getCodecName() {
        return this.codecName;
    }

    public boolean accept(File file) {
        if (file == null || !file.exists() || !file.canRead()) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        if (file.length() < 8L) {
            return false;
        }
        try {
            JAIFileFilter.readHeaderSample(file, this.headerBytes);
        }
        catch (Exception ex) {
            return false;
        }
        for (int i = 0; i < this.activeCodecs.length; ++i) {
            if (!this.activeCodecs[i].isFormatRecognized(this.headerBytes)) continue;
            return true;
        }
        return false;
    }

    private void setupFilter(String codecName) {
        this.codecName = codecName;
        this.decription = "All Supported Images";
        this.activeCodecs = null;
        if (codecName == null) {
            Enumeration codecEnumeration = ImageCodec.getCodecs();
            ArrayList codecArray = new ArrayList();
            while (codecEnumeration.hasMoreElements()) {
                codecArray.add(codecEnumeration.nextElement());
            }
            this.activeCodecs = codecArray.toArray(new ImageCodec[codecArray.size()]);
        } else {
            ImageCodec codec = ImageCodec.getCodec(codecName);
            if (codec != null) {
                this.activeCodecs = new ImageCodec[1];
                this.activeCodecs[0] = codec;
                this.codecName = codecName;
                this.decription = codecName.toUpperCase();
            }
        }
        if (this.activeCodecs == null) {
            throw new RuntimeException("Unable to find codecs for: " + codecName);
        }
        for (int i = 0; i < this.activeCodecs.length; ++i) {
            int h = this.activeCodecs[i].getNumHeaderBytes();
            if (h == 0) {
                throw new RuntimeException("Codec " + this.activeCodecs[i].getFormatName() + " unable to recognize its files by header.");
            }
            if (h <= this.maxHeaderSize) continue;
            this.maxHeaderSize = h;
        }
        if (this.maxHeaderSize > 8) {
            throw new RuntimeException("MIN_IMAGE_FILE_SIZE set too low, need to be at least " + this.maxHeaderSize);
        }
        this.headerBytes = new byte[this.maxHeaderSize];
    }
}

