/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ij.jaiio;

import ij.ImagePlus;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import net.sf.ij.jaiio.UnsupportedImageModelException;
import non_com.media.jai.DataBufferDouble;
import non_com.media.jai.DataBufferFloat;

public class ImagePlusCreator {
    private ImagePlusCreator() {
    }

    public static WritableRaster forceTileUpdate(RenderedImage ri) {
        Raster r = ri.getData();
        if (!(r instanceof WritableRaster)) {
            r = Raster.createWritableRaster(r.getSampleModel(), r.getDataBuffer(), null);
        }
        WritableRaster wr = (WritableRaster)r;
        int xTiles = ri.getNumXTiles();
        int yTiles = ri.getNumYTiles();
        for (int ty = 0; ty < yTiles; ++ty) {
            for (int tx = 0; tx < xTiles; ++tx) {
                wr.setRect(ri.getTile(tx, ty));
            }
        }
        return wr;
    }

    public static ImageProcessor createProcessor(int w, int h, DataBuffer buffer, ColorModel cm) throws UnsupportedImageModelException {
        if (buffer.getOffset() != 0) {
            throw new UnsupportedImageModelException("Expecting BufferData with no offset.");
        }
        switch (buffer.getDataType()) {
            case 0: {
                return new ByteProcessor(w, h, ((DataBufferByte)buffer).getData(), cm);
            }
            case 1: {
                return new ShortProcessor(w, h, ((DataBufferUShort)buffer).getData(), cm);
            }
            case 2: {
                short[] pixels = ((DataBufferShort)buffer).getData();
                for (int i = 0; i < pixels.length; ++i) {
                    pixels[i] = (short)(pixels[i] + 32768);
                }
                return new ShortProcessor(w, h, pixels, cm);
            }
            case 3: {
                return new FloatProcessor(w, h, ((DataBufferInt)buffer).getData());
            }
            case 4: {
                DataBufferFloat dbFloat = (DataBufferFloat)buffer;
                return new FloatProcessor(w, h, dbFloat.getData(), cm);
            }
            case 5: {
                return new FloatProcessor(w, h, ((DataBufferDouble)buffer).getData());
            }
            case 32: {
                throw new UnsupportedImageModelException("Pixel type is undefined.");
            }
        }
        throw new UnsupportedImageModelException("Unrecognized DataBuffer data type");
    }

    public static ImagePlus create(WritableRaster r, ColorModel cm) throws UnsupportedImageModelException {
        DataBuffer db = r.getDataBuffer();
        int numBanks = db.getNumBanks();
        if (numBanks > 1 && cm == null) {
            throw new UnsupportedImageModelException("Don't know what to do with image with no color model and multiple banks.");
        }
        SampleModel sm = r.getSampleModel();
        int dbType = db.getDataType();
        if (numBanks > 1 || sm.getNumBands() > 1) {
            BufferedImage bi = new BufferedImage(cm, r, false, null);
            return new ImagePlus(null, (ImageProcessor)new ColorProcessor((Image)bi));
        }
        if (sm.getSampleSize(0) < 8) {
            BufferedImage bi = new BufferedImage(cm, r, false, null);
            return new ImagePlus(null, (ImageProcessor)new ByteProcessor((Image)bi));
        }
        if (!(cm instanceof IndexColorModel)) {
            cm = null;
        }
        ImageProcessor ip = ImagePlusCreator.createProcessor(r.getWidth(), r.getHeight(), r.getDataBuffer(), cm);
        ImagePlus im = new ImagePlus(null, ip);
        if (db.getDataType() == 2) {
            Calibration cal = new Calibration(im);
            double[] coeff = new double[]{-32768.0, 1.0};
            cal.setFunction(0, coeff, "gray value");
            im.setCalibration(cal);
        } else if (cm == null) {
            Calibration cal = im.getCalibration();
            im.setCalibration(null);
            ImageStatistics stats = im.getStatistics();
            im.setCalibration(cal);
            ip.setMinAndMax(stats.min, stats.max);
            im.updateImage();
        }
        return im;
    }
}

