/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ij.jaiio;

import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JFileChooser;
import net.sf.ij.jaiio.JAIFileFilter;
import net.sf.ij.jaiio.JAIFilePreviewer;
import non_com.media.jai.codec.ImageCodec;

public class ImageFileChooser
extends JFileChooser {
    JAIFilePreviewer previewer = new JAIFilePreviewer(this);

    public ImageFileChooser(File currentDirectory) {
        super(currentDirectory);
        this.setAccessory(this.previewer);
        JAIFileFilter allSupportedFileFilter = new JAIFileFilter();
        this.addChoosableFileFilter(allSupportedFileFilter);
        Enumeration codecs = ImageCodec.getCodecs();
        TreeSet<String> codecSet = new TreeSet<String>();
        while (codecs.hasMoreElements()) {
            ImageCodec thisCodec = (ImageCodec)codecs.nextElement();
            codecSet.add(thisCodec.getFormatName());
        }
        Iterator i = codecSet.iterator();
        while (i.hasNext()) {
            try {
                this.addChoosableFileFilter(new JAIFileFilter((String)i.next()));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.setFileFilter(allSupportedFileFilter);
        this.validate();
    }

    public int[] getPageIndex() {
        File[] selection = this.getSelectedFiles();
        if (selection != null && selection.length == 1) {
            return this.previewer.getPageIndex();
        }
        return null;
    }
}

