/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ij.jaiio;

import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import non_com.media.jai.DataBufferFloat;
import non_com.media.jai.RasterFactory;
import non_com.media.jai.codec.ImageCodec;

public class BufferedImageCreator {
    private BufferedImageCreator() {
    }

    public static BufferedImage create(ImagePlus src, int sliceNb) {
        int oldSliceNb = src.getCurrentSlice();
        src.setSlice(sliceNb + 1);
        ImageProcessor ip = src.getProcessor().duplicate();
        src.setSlice(oldSliceNb);
        switch (src.getType()) {
            case 0: {
                ColorModel cm = BufferedImageCreator.createGray8ColorModel(src.isInvertedLut());
                if (cm != null && cm instanceof IndexColorModel) {
                    return BufferedImageCreator.create((ByteProcessor)ip, (IndexColorModel)cm);
                }
                return BufferedImageCreator.create((ByteProcessor)ip);
            }
            case 1: {
                return BufferedImageCreator.create((ShortProcessor)ip);
            }
            case 2: {
                return BufferedImageCreator.create((FloatProcessor)ip);
            }
            case 3: {
                return BufferedImageCreator.createColor256((ByteProcessor)ip, (IndexColorModel)ip.getColorModel());
            }
            case 4: {
                return BufferedImageCreator.create((ColorProcessor)ip);
            }
        }
        throw new IllegalArgumentException("Unrecognized image type: " + src.getType() + ".");
    }

    public static BufferedImage[] createArray(ImagePlus src) {
        BufferedImage[] r = new BufferedImage[src.getStackSize()];
        int oldSliceNb = src.getCurrentSlice();
        for (int i = 0; i < r.length; ++i) {
            src.setSlice(i + 1);
            r[i] = BufferedImageCreator.create(src, i);
        }
        src.setSlice(oldSliceNb);
        return r;
    }

    public static BufferedImage create(ByteProcessor src) {
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        for (int i = 0; i < 256; ++i) {
            g[i] = b[i] = (byte)(i & 0xFF);
            r[i] = b[i];
        }
        IndexColorModel icm = new IndexColorModel(8, 256, r, g, b);
        return BufferedImageCreator.create(src, icm);
    }

    public static BufferedImage createColor256(ByteProcessor src, IndexColorModel icm) {
        IndexColorModel icm256;
        int mapSize = icm.getMapSize();
        if (mapSize == 256) {
            icm256 = icm;
        } else if (mapSize < 256) {
            byte[] r = new byte[256];
            byte[] g = new byte[256];
            byte[] b = new byte[256];
            icm.getReds(r);
            icm.getGreens(g);
            icm.getBlues(b);
            icm256 = new IndexColorModel(8, 256, r, g, b);
        } else {
            throw new UnsupportedOperationException("Unable to properly decode this image (color map).\nPlease report this problem at http://ij-plugins.sf.net\nor by sending email to 'jsacha at users.sourceforge.net'\n  Map size    = " + mapSize + ".");
        }
        return BufferedImageCreator.create(src, icm256);
    }

    public static BufferedImage create(ByteProcessor src, IndexColorModel icm) {
        WritableRaster wr = icm.createCompatibleWritableRaster(src.getWidth(), src.getHeight());
        byte[] bitsOn = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
        byte[] srcPixels = (byte[])src.getPixels();
        DataBufferByte dataBuffer = (DataBufferByte)wr.getDataBuffer();
        byte[] destPixels = dataBuffer.getData();
        int mapSize = icm.getMapSize();
        if (mapSize == 256) {
            System.arraycopy(srcPixels, 0, destPixels, 0, destPixels.length);
            return new BufferedImage(icm, wr, false, null);
        }
        if (mapSize == 2) {
            int srcWidth = src.getWidth();
            int destWidth = (src.getWidth() + 7) / 8;
            int expectedDestSize = destWidth * src.getHeight();
            if (destPixels.length != expectedDestSize) {
                throw new IllegalStateException("Internal error: wrong size of destPixels.");
            }
            for (int i = 0; i < destPixels.length; ++i) {
                byte destByte = 0;
                int offset = i / destWidth * srcWidth + i % destWidth * 8;
                for (int j = 0; j < 8 && j + offset < srcPixels.length; ++j) {
                    if (srcPixels[j + offset] == 0) continue;
                    destByte = (byte)(destByte + bitsOn[j]);
                }
                destPixels[i] = destByte;
            }
            return new BufferedImage(icm, wr, false, null);
        }
        throw new UnsupportedOperationException("Unable to properly decode this image (color map).\nPlease report this problem at http://ij-plugins.sf.net\nor by sending email to 'jsacha at users.sourceforge.net'\n  Map size    = " + mapSize + "\n" + "  Src pixels  = " + srcPixels.length + "\n" + "  Dest pixels = " + destPixels.length);
    }

    public static BufferedImage create(ShortProcessor src) {
        BufferedImage bufferedImage = new BufferedImage(src.getWidth(), src.getHeight(), 11);
        Raster raster = bufferedImage.getData();
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        System.arraycopy(src.getPixels(), 0, dataBuffer.getData(), 0, dataBuffer.getData().length);
        bufferedImage.setData(raster);
        return bufferedImage;
    }

    public static BufferedImage create(FloatProcessor src) {
        int w = src.getWidth();
        int h = src.getHeight();
        int nbBands = 1;
        int[] rgbOffset = new int[nbBands];
        SampleModel sampleModel = RasterFactory.createPixelInterleavedSampleModel(4, w, h, nbBands, nbBands * w, rgbOffset);
        ColorModel colorModel = ImageCodec.createComponentColorModel(sampleModel);
        float[] pixels = (float[])src.getPixels();
        DataBufferFloat dataBuffer = new DataBufferFloat(pixels, pixels.length);
        WritableRaster raster = RasterFactory.createWritableRaster(sampleModel, dataBuffer, new Point(0, 0));
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static BufferedImage create(ColorProcessor src) {
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] bits = new int[]{8, 8, 8};
        ComponentColorModel cm = new ComponentColorModel(cs, bits, false, false, 1, 0);
        WritableRaster raster = ((ColorModel)cm).createCompatibleWritableRaster(src.getWidth(), src.getHeight());
        DataBufferByte dataBuffer = (DataBufferByte)raster.getDataBuffer();
        byte[] data = dataBuffer.getData();
        int n = ((int[])src.getPixels()).length;
        byte[] r = new byte[n];
        byte[] g = new byte[n];
        byte[] b = new byte[n];
        src.getRGB(r, g, b);
        for (int i = 0; i < n; ++i) {
            int offset = i * 3;
            data[offset] = r[i];
            data[offset + 1] = g[i];
            data[offset + 2] = b[i];
        }
        return new BufferedImage(cm, raster, false, null);
    }

    private static ColorModel createGray8ColorModel(boolean invertLut) {
        byte[] rLUT = new byte[256];
        byte[] gLUT = new byte[256];
        byte[] bLUT = new byte[256];
        if (invertLut) {
            for (int i = 0; i < 256; ++i) {
                rLUT[255 - i] = (byte)i;
                gLUT[255 - i] = (byte)i;
                bLUT[255 - i] = (byte)i;
            }
        } else {
            for (int i = 0; i < 256; ++i) {
                rLUT[i] = (byte)i;
                gLUT[i] = (byte)i;
                bLUT[i] = (byte)i;
            }
        }
        return new IndexColorModel(8, 256, rLUT, gLUT, bLUT);
    }
}

